// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_xr_depth_state_init.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"dataFormatPreference",
"depthTypeRequest",
"matchDepthView",
"usagePreference",
};


}  // namespace 

XRDepthStateInit* XRDepthStateInit::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  XRDepthStateInit* dictionary = MakeGarbageCollected<XRDepthStateInit>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "XRDepthStateInit";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 XRDepthStateInit::XRDepthStateInit() {
  
}

 XRDepthStateInit::XRDepthStateInit(v8::Isolate* isolate) {
  
}



void XRDepthStateInit::setDataFormatPreference(const Vector<V8XRDepthDataFormat>& value) {
  member_data_format_preference_ = value;
}

void XRDepthStateInit::setDataFormatPreference(Vector<V8XRDepthDataFormat>&& value) {
  member_data_format_preference_ = std::move(value);
}




Vector<V8XRDepthType> XRDepthStateInit::getDepthTypeRequestOr(const Vector<V8XRDepthType>& fallback_value) const {
  if (!hasDepthTypeRequest()) {
  return fallback_value;
}
return member_depth_type_request_;
}

Vector<V8XRDepthType> XRDepthStateInit::getDepthTypeRequestOr(Vector<V8XRDepthType>&& fallback_value) const {
  if (!hasDepthTypeRequest()) {
  return std::move(fallback_value);
}
return member_depth_type_request_;
}

void XRDepthStateInit::setDepthTypeRequest(const Vector<V8XRDepthType>& value) {
  member_depth_type_request_ = value;
has_depth_type_request_ = true;
}

void XRDepthStateInit::setDepthTypeRequest(Vector<V8XRDepthType>&& value) {
  member_depth_type_request_ = std::move(value);
has_depth_type_request_ = true;
}











void XRDepthStateInit::setUsagePreference(const Vector<V8XRDepthUsage>& value) {
  member_usage_preference_ = value;
}

void XRDepthStateInit::setUsagePreference(Vector<V8XRDepthUsage>&& value) {
  member_usage_preference_ = std::move(value);
}




void XRDepthStateInit::Trace(Visitor* visitor) const {
  bindings::InputDictionaryBase::Trace(visitor);
}

void XRDepthStateInit::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "XRDepthStateInit";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("dataFormatPreference");
constexpr bool is_required = true;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<V8XRDepthDataFormat>, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_data_format_preference_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("depthTypeRequest");
constexpr bool is_optional = false;
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<V8XRDepthType>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_depth_type_request_, member_depth_type_request_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("matchDepthView");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_match_depth_view_, member_match_depth_view_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("usagePreference");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<V8XRDepthUsage>, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_usage_preference_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> XRDepthStateInit::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
