// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEB_PRINT_JOB_TEMPLATE_ATTRIBUTES_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEB_PRINT_JOB_TEMPLATE_ATTRIBUTES_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_web_print_color_mode.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_web_print_quality.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_web_printing_multiple_document_handling.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_web_printing_orientation_requested.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_web_printing_sides.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class AbortSignal;
class ExceptionState;
class WebPrintingMediaCollectionRequested;
class WebPrintingResolution;

class MODULES_EXPORT WebPrintJobTemplateAttributes : public bindings::InputDictionaryBase {
  
  public:
static WebPrintJobTemplateAttributes* Create() {
  return MakeGarbageCollected<WebPrintJobTemplateAttributes>();
}
static WebPrintJobTemplateAttributes* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<WebPrintJobTemplateAttributes>(isolate);
}
static WebPrintJobTemplateAttributes* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  WebPrintJobTemplateAttributes();
explicit  WebPrintJobTemplateAttributes(v8::Isolate* isolate);

bool hasCopies() const {
  return has_copies_;
}
uint32_t copies() const {
  DCHECK(hasCopies());
return member_copies_;
}
uint32_t getCopiesOr(uint32_t fallback_value) const {
  if (!hasCopies()) {
  return fallback_value;
}
return member_copies_;
}
void setCopies(uint32_t value) {
  member_copies_ = value;
has_copies_ = true;
}

bool hasMediaCol() const {
  return has_media_col_;
}
WebPrintingMediaCollectionRequested* mediaCol() const {
  DCHECK(hasMediaCol());
return member_media_col_.Get();
}
WebPrintingMediaCollectionRequested* getMediaColOr(WebPrintingMediaCollectionRequested* fallback_value) const {
  if (!hasMediaCol()) {
  return fallback_value;
}
return member_media_col_.Get();
}
void setMediaCol(WebPrintingMediaCollectionRequested* value) {
  member_media_col_ = value;
has_media_col_ = true;
DCHECK(member_media_col_);
}

bool hasMediaSource() const {
  return has_media_source_;
}
const String& mediaSource() const {
  DCHECK(hasMediaSource());
return member_media_source_;
}
String getMediaSourceOr(const String& fallback_value) const;
String getMediaSourceOr(String&& fallback_value) const;
void setMediaSource(const String& value);
void setMediaSource(String&& value);

bool hasMultipleDocumentHandling() const {
  return has_multiple_document_handling_;
}
V8WebPrintingMultipleDocumentHandling multipleDocumentHandling() const {
  DCHECK(hasMultipleDocumentHandling());
return member_multiple_document_handling_;
}
V8WebPrintingMultipleDocumentHandling getMultipleDocumentHandlingOr(V8WebPrintingMultipleDocumentHandling fallback_value) const {
  if (!hasMultipleDocumentHandling()) {
  return fallback_value;
}
return member_multiple_document_handling_;
}
void setMultipleDocumentHandling(V8WebPrintingMultipleDocumentHandling value) {
  member_multiple_document_handling_ = value;
has_multiple_document_handling_ = true;
}
void setMultipleDocumentHandling(V8WebPrintingMultipleDocumentHandling::Enum value) {
  member_multiple_document_handling_ = V8WebPrintingMultipleDocumentHandling(value);
has_multiple_document_handling_ = true;
}

bool hasOrientationRequested() const {
  return has_orientation_requested_;
}
V8WebPrintingOrientationRequested orientationRequested() const {
  DCHECK(hasOrientationRequested());
return member_orientation_requested_;
}
V8WebPrintingOrientationRequested getOrientationRequestedOr(V8WebPrintingOrientationRequested fallback_value) const {
  if (!hasOrientationRequested()) {
  return fallback_value;
}
return member_orientation_requested_;
}
void setOrientationRequested(V8WebPrintingOrientationRequested value) {
  member_orientation_requested_ = value;
has_orientation_requested_ = true;
}
void setOrientationRequested(V8WebPrintingOrientationRequested::Enum value) {
  member_orientation_requested_ = V8WebPrintingOrientationRequested(value);
has_orientation_requested_ = true;
}

bool hasPrintColorMode() const {
  return has_print_color_mode_;
}
V8WebPrintColorMode printColorMode() const {
  DCHECK(hasPrintColorMode());
return member_print_color_mode_;
}
V8WebPrintColorMode getPrintColorModeOr(V8WebPrintColorMode fallback_value) const {
  if (!hasPrintColorMode()) {
  return fallback_value;
}
return member_print_color_mode_;
}
void setPrintColorMode(V8WebPrintColorMode value) {
  member_print_color_mode_ = value;
has_print_color_mode_ = true;
}
void setPrintColorMode(V8WebPrintColorMode::Enum value) {
  member_print_color_mode_ = V8WebPrintColorMode(value);
has_print_color_mode_ = true;
}

bool hasPrintQuality() const {
  return has_print_quality_;
}
V8WebPrintQuality printQuality() const {
  DCHECK(hasPrintQuality());
return member_print_quality_;
}
V8WebPrintQuality getPrintQualityOr(V8WebPrintQuality fallback_value) const {
  if (!hasPrintQuality()) {
  return fallback_value;
}
return member_print_quality_;
}
void setPrintQuality(V8WebPrintQuality value) {
  member_print_quality_ = value;
has_print_quality_ = true;
}
void setPrintQuality(V8WebPrintQuality::Enum value) {
  member_print_quality_ = V8WebPrintQuality(value);
has_print_quality_ = true;
}

bool hasPrinterResolution() const {
  return has_printer_resolution_;
}
WebPrintingResolution* printerResolution() const {
  DCHECK(hasPrinterResolution());
return member_printer_resolution_.Get();
}
WebPrintingResolution* getPrinterResolutionOr(WebPrintingResolution* fallback_value) const {
  if (!hasPrinterResolution()) {
  return fallback_value;
}
return member_printer_resolution_.Get();
}
void setPrinterResolution(WebPrintingResolution* value) {
  member_printer_resolution_ = value;
has_printer_resolution_ = true;
DCHECK(member_printer_resolution_);
}

bool hasSides() const {
  return has_sides_;
}
V8WebPrintingSides sides() const {
  DCHECK(hasSides());
return member_sides_;
}
V8WebPrintingSides getSidesOr(V8WebPrintingSides fallback_value) const {
  if (!hasSides()) {
  return fallback_value;
}
return member_sides_;
}
void setSides(V8WebPrintingSides value) {
  member_sides_ = value;
has_sides_ = true;
}
void setSides(V8WebPrintingSides::Enum value) {
  member_sides_ = V8WebPrintingSides(value);
has_sides_ = true;
}

bool hasSignal() const {
  return has_signal_;
}
AbortSignal* signal() const {
  DCHECK(hasSignal());
return member_signal_.Get();
}
AbortSignal* getSignalOr(AbortSignal* fallback_value) const {
  if (!hasSignal()) {
  return fallback_value;
}
return member_signal_.Get();
}
void setSignal(AbortSignal* value) {
  member_signal_ = value;
has_signal_ = true;
DCHECK(member_signal_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 10;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_copies_ = false;
bool has_media_col_ = false;
bool has_media_source_ = false;
bool has_multiple_document_handling_ = false;
bool has_orientation_requested_ = false;
bool has_print_color_mode_ = false;
bool has_print_quality_ = false;
bool has_printer_resolution_ = false;
bool has_sides_ = false;
bool has_signal_ = false;

uint32_t member_copies_;
Member<WebPrintingMediaCollectionRequested> member_media_col_;
String member_media_source_;
V8WebPrintingMultipleDocumentHandling member_multiple_document_handling_{static_cast<V8WebPrintingMultipleDocumentHandling::Enum>(0)};
V8WebPrintingOrientationRequested member_orientation_requested_{static_cast<V8WebPrintingOrientationRequested::Enum>(0)};
V8WebPrintColorMode member_print_color_mode_{static_cast<V8WebPrintColorMode::Enum>(0)};
V8WebPrintQuality member_print_quality_{static_cast<V8WebPrintQuality::Enum>(0)};
Member<WebPrintingResolution> member_printer_resolution_;
V8WebPrintingSides member_sides_{static_cast<V8WebPrintingSides::Enum>(0)};
Member<AbortSignal> member_signal_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEB_PRINT_JOB_TEMPLATE_ATTRIBUTES_H_
