// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WAVE_SHAPER_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WAVE_SHAPER_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_audio_node_options.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_over_sample_type.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT WaveShaperOptions : public AudioNodeOptions {
  
  public:
static WaveShaperOptions* Create() {
  return MakeGarbageCollected<WaveShaperOptions>();
}
static WaveShaperOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<WaveShaperOptions>(isolate);
}
static WaveShaperOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  WaveShaperOptions();
explicit  WaveShaperOptions(v8::Isolate* isolate);

bool hasCurve() const {
  return has_curve_;
}
const Vector<float>& curve() const {
  DCHECK(hasCurve());
return member_curve_;
}
Vector<float> getCurveOr(const Vector<float>& fallback_value) const;
Vector<float> getCurveOr(Vector<float>&& fallback_value) const;
void setCurve(const Vector<float>& value);
void setCurve(Vector<float>&& value);

bool hasOversample() const {
  return true;
}
V8OverSampleType oversample() const {
  return member_oversample_;
}
void setOversample(V8OverSampleType value) {
  member_oversample_ = value;
}
void setOversample(V8OverSampleType::Enum value) {
  member_oversample_ = V8OverSampleType(value);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = AudioNodeOptions::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_curve_ = false;

Vector<float> member_curve_;
V8OverSampleType member_oversample_{V8OverSampleType::Enum::kNone};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WAVE_SHAPER_OPTIONS_H_
