// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIRTUAL_SENSOR_READING_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIRTUAL_SENSOR_READING_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class  VirtualSensorReading : public bindings::InputDictionaryBase {
  
  public:
static VirtualSensorReading* Create() {
  return MakeGarbageCollected<VirtualSensorReading>();
}
static VirtualSensorReading* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<VirtualSensorReading>(isolate);
}
static VirtualSensorReading* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  VirtualSensorReading();
explicit  VirtualSensorReading(v8::Isolate* isolate);

bool hasAlpha() const {
  return has_alpha_;
}
double alpha() const {
  DCHECK(hasAlpha());
return member_alpha_;
}
double getAlphaOr(double fallback_value) const {
  if (!hasAlpha()) {
  return fallback_value;
}
return member_alpha_;
}
void setAlpha(double value) {
  member_alpha_ = value;
has_alpha_ = true;
}

bool hasBeta() const {
  return has_beta_;
}
double beta() const {
  DCHECK(hasBeta());
return member_beta_;
}
double getBetaOr(double fallback_value) const {
  if (!hasBeta()) {
  return fallback_value;
}
return member_beta_;
}
void setBeta(double value) {
  member_beta_ = value;
has_beta_ = true;
}

bool hasGamma() const {
  return has_gamma_;
}
double gamma() const {
  DCHECK(hasGamma());
return member_gamma_;
}
double getGammaOr(double fallback_value) const {
  if (!hasGamma()) {
  return fallback_value;
}
return member_gamma_;
}
void setGamma(double value) {
  member_gamma_ = value;
has_gamma_ = true;
}

bool hasIlluminance() const {
  return has_illuminance_;
}
double illuminance() const {
  DCHECK(hasIlluminance());
return member_illuminance_;
}
double getIlluminanceOr(double fallback_value) const {
  if (!hasIlluminance()) {
  return fallback_value;
}
return member_illuminance_;
}
void setIlluminance(double value) {
  member_illuminance_ = value;
has_illuminance_ = true;
}

bool hasX() const {
  return has_x_;
}
double x() const {
  DCHECK(hasX());
return member_x_;
}
double getXOr(double fallback_value) const {
  if (!hasX()) {
  return fallback_value;
}
return member_x_;
}
void setX(double value) {
  member_x_ = value;
has_x_ = true;
}

bool hasY() const {
  return has_y_;
}
double y() const {
  DCHECK(hasY());
return member_y_;
}
double getYOr(double fallback_value) const {
  if (!hasY()) {
  return fallback_value;
}
return member_y_;
}
void setY(double value) {
  member_y_ = value;
has_y_ = true;
}

bool hasZ() const {
  return has_z_;
}
double z() const {
  DCHECK(hasZ());
return member_z_;
}
double getZOr(double fallback_value) const {
  if (!hasZ()) {
  return fallback_value;
}
return member_z_;
}
void setZ(double value) {
  member_z_ = value;
has_z_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 7;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_alpha_ = false;
bool has_beta_ = false;
bool has_gamma_ = false;
bool has_illuminance_ = false;
bool has_x_ = false;
bool has_y_ = false;
bool has_z_ = false;

double member_alpha_;
double member_beta_;
double member_gamma_;
double member_illuminance_;
double member_x_;
double member_y_;
double member_z_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIRTUAL_SENSOR_READING_H_
