// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIDEO_FRAME_COPY_TO_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIDEO_FRAME_COPY_TO_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_predefined_color_space.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_video_pixel_format.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class DOMRectInit;
class ExceptionState;
class PlaneLayout;

class MODULES_EXPORT VideoFrameCopyToOptions : public bindings::InputDictionaryBase {
  
  public:
static VideoFrameCopyToOptions* Create() {
  return MakeGarbageCollected<VideoFrameCopyToOptions>();
}
static VideoFrameCopyToOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<VideoFrameCopyToOptions>(isolate);
}
static VideoFrameCopyToOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  VideoFrameCopyToOptions();
explicit  VideoFrameCopyToOptions(v8::Isolate* isolate);

bool hasColorSpace() const {
  return has_color_space_;
}
V8PredefinedColorSpace colorSpace() const {
  DCHECK(hasColorSpace());
return member_color_space_;
}
V8PredefinedColorSpace getColorSpaceOr(V8PredefinedColorSpace fallback_value) const {
  if (!hasColorSpace()) {
  return fallback_value;
}
return member_color_space_;
}
void setColorSpace(V8PredefinedColorSpace value) {
  member_color_space_ = value;
has_color_space_ = true;
}
void setColorSpace(V8PredefinedColorSpace::Enum value) {
  member_color_space_ = V8PredefinedColorSpace(value);
has_color_space_ = true;
}

bool hasFormat() const {
  return has_format_;
}
V8VideoPixelFormat format() const {
  DCHECK(hasFormat());
return member_format_;
}
V8VideoPixelFormat getFormatOr(V8VideoPixelFormat fallback_value) const {
  if (!hasFormat()) {
  return fallback_value;
}
return member_format_;
}
void setFormat(V8VideoPixelFormat value) {
  member_format_ = value;
has_format_ = true;
}
void setFormat(V8VideoPixelFormat::Enum value) {
  member_format_ = V8VideoPixelFormat(value);
has_format_ = true;
}

bool hasLayout() const {
  return has_layout_;
}
const HeapVector<Member<PlaneLayout>>& layout() const {
  DCHECK(hasLayout());
return member_layout_;
}
HeapVector<Member<PlaneLayout>> getLayoutOr(const HeapVector<Member<PlaneLayout>>& fallback_value) const;
HeapVector<Member<PlaneLayout>> getLayoutOr(HeapVector<Member<PlaneLayout>>&& fallback_value) const;
void setLayout(const HeapVector<Member<PlaneLayout>>& value);
void setLayout(HeapVector<Member<PlaneLayout>>&& value);

bool hasRect() const {
  return has_rect_;
}
DOMRectInit* rect() const {
  DCHECK(hasRect());
return member_rect_.Get();
}
DOMRectInit* getRectOr(DOMRectInit* fallback_value) const {
  if (!hasRect()) {
  return fallback_value;
}
return member_rect_.Get();
}
void setRect(DOMRectInit* value) {
  member_rect_ = value;
has_rect_ = true;
DCHECK(member_rect_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_color_space_ = false;
bool has_format_ = false;
bool has_layout_ = false;
bool has_rect_ = false;

V8PredefinedColorSpace member_color_space_{static_cast<V8PredefinedColorSpace::Enum>(0)};
V8VideoPixelFormat member_format_{static_cast<V8VideoPixelFormat::Enum>(0)};
HeapVector<Member<PlaneLayout>> member_layout_;
Member<DOMRectInit> member_rect_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIDEO_FRAME_COPY_TO_OPTIONS_H_
