// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIDEO_FRAME_BUFFER_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIDEO_FRAME_BUFFER_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_video_pixel_format.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class DOMRectInit;
class ExceptionState;
class PlaneLayout;
class VideoColorSpaceInit;

class MODULES_EXPORT VideoFrameBufferInit : public bindings::InputDictionaryBase {
  
  public:
static VideoFrameBufferInit* Create() {
  return MakeGarbageCollected<VideoFrameBufferInit>();
}
static VideoFrameBufferInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<VideoFrameBufferInit>(isolate);
}
static VideoFrameBufferInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  VideoFrameBufferInit();
explicit  VideoFrameBufferInit(v8::Isolate* isolate);

bool hasCodedHeight() const {
  return true;
}
uint32_t codedHeight() const {
  return member_coded_height_;
}
void setCodedHeight(uint32_t value) {
  member_coded_height_ = value;
}

bool hasCodedWidth() const {
  return true;
}
uint32_t codedWidth() const {
  return member_coded_width_;
}
void setCodedWidth(uint32_t value) {
  member_coded_width_ = value;
}

bool hasColorSpace() const {
  return has_color_space_;
}
VideoColorSpaceInit* colorSpace() const {
  DCHECK(hasColorSpace());
return member_color_space_.Get();
}
VideoColorSpaceInit* getColorSpaceOr(VideoColorSpaceInit* fallback_value) const {
  if (!hasColorSpace()) {
  return fallback_value;
}
return member_color_space_.Get();
}
void setColorSpace(VideoColorSpaceInit* value) {
  member_color_space_ = value;
has_color_space_ = true;
DCHECK(member_color_space_);
}

bool hasDisplayHeight() const {
  return has_display_height_;
}
uint32_t displayHeight() const {
  DCHECK(hasDisplayHeight());
return member_display_height_;
}
uint32_t getDisplayHeightOr(uint32_t fallback_value) const {
  if (!hasDisplayHeight()) {
  return fallback_value;
}
return member_display_height_;
}
void setDisplayHeight(uint32_t value) {
  member_display_height_ = value;
has_display_height_ = true;
}

bool hasDisplayWidth() const {
  return has_display_width_;
}
uint32_t displayWidth() const {
  DCHECK(hasDisplayWidth());
return member_display_width_;
}
uint32_t getDisplayWidthOr(uint32_t fallback_value) const {
  if (!hasDisplayWidth()) {
  return fallback_value;
}
return member_display_width_;
}
void setDisplayWidth(uint32_t value) {
  member_display_width_ = value;
has_display_width_ = true;
}

bool hasDuration() const {
  return has_duration_;
}
uint64_t duration() const {
  DCHECK(hasDuration());
return member_duration_;
}
uint64_t getDurationOr(uint64_t fallback_value) const {
  if (!hasDuration()) {
  return fallback_value;
}
return member_duration_;
}
void setDuration(uint64_t value) {
  member_duration_ = value;
has_duration_ = true;
}

bool hasFlip() const {
  return true;
}
bool flip() const {
  return member_flip_;
}
void setFlip(bool value) {
  member_flip_ = value;
}

bool hasFormat() const {
  return true;
}
V8VideoPixelFormat format() const {
  return member_format_;
}
void setFormat(V8VideoPixelFormat value) {
  member_format_ = value;
}
void setFormat(V8VideoPixelFormat::Enum value) {
  member_format_ = V8VideoPixelFormat(value);
}

bool hasLayout() const {
  return has_layout_;
}
const HeapVector<Member<PlaneLayout>>& layout() const {
  DCHECK(hasLayout());
return member_layout_;
}
HeapVector<Member<PlaneLayout>> getLayoutOr(const HeapVector<Member<PlaneLayout>>& fallback_value) const;
HeapVector<Member<PlaneLayout>> getLayoutOr(HeapVector<Member<PlaneLayout>>&& fallback_value) const;
void setLayout(const HeapVector<Member<PlaneLayout>>& value);
void setLayout(HeapVector<Member<PlaneLayout>>&& value);

bool hasRotation() const {
  return true;
}
double rotation() const {
  return member_rotation_;
}
void setRotation(double value) {
  member_rotation_ = value;
}

bool hasTimestamp() const {
  return true;
}
int64_t timestamp() const {
  return member_timestamp_;
}
void setTimestamp(int64_t value) {
  member_timestamp_ = value;
}

bool hasTransfer() const {
  return true;
}
const HeapVector<Member<DOMArrayBuffer>>& transfer() const {
  return member_transfer_;
}
void setTransfer(const HeapVector<Member<DOMArrayBuffer>>& value);
void setTransfer(HeapVector<Member<DOMArrayBuffer>>&& value);

bool hasVisibleRect() const {
  return has_visible_rect_;
}
DOMRectInit* visibleRect() const {
  DCHECK(hasVisibleRect());
return member_visible_rect_.Get();
}
DOMRectInit* getVisibleRectOr(DOMRectInit* fallback_value) const {
  if (!hasVisibleRect()) {
  return fallback_value;
}
return member_visible_rect_.Get();
}
void setVisibleRect(DOMRectInit* value) {
  member_visible_rect_ = value;
has_visible_rect_ = true;
DCHECK(member_visible_rect_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 13;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_color_space_ = false;
bool has_display_height_ = false;
bool has_display_width_ = false;
bool has_duration_ = false;
bool has_layout_ = false;
bool has_visible_rect_ = false;

uint32_t member_coded_height_;
uint32_t member_coded_width_;
Member<VideoColorSpaceInit> member_color_space_;
uint32_t member_display_height_;
uint32_t member_display_width_;
uint64_t member_duration_;
bool member_flip_{false};
V8VideoPixelFormat member_format_{static_cast<V8VideoPixelFormat::Enum>(0)};
HeapVector<Member<PlaneLayout>> member_layout_;
double member_rotation_{0};
int64_t member_timestamp_;
HeapVector<Member<DOMArrayBuffer>> member_transfer_;
Member<DOMRectInit> member_visible_rect_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIDEO_FRAME_BUFFER_INIT_H_
