// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_video_frame_buffer_init.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_dom_rect_init.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_plane_layout.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_video_color_space_init.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"codedHeight",
"codedWidth",
"colorSpace",
"displayHeight",
"displayWidth",
"duration",
"flip",
"format",
"layout",
"rotation",
"timestamp",
"transfer",
"visibleRect",
};


}  // namespace 

VideoFrameBufferInit* VideoFrameBufferInit::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  VideoFrameBufferInit* dictionary = MakeGarbageCollected<VideoFrameBufferInit>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "VideoFrameBufferInit";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 VideoFrameBufferInit::VideoFrameBufferInit() {
  
}

 VideoFrameBufferInit::VideoFrameBufferInit(v8::Isolate* isolate) {
  
}



















































HeapVector<Member<PlaneLayout>> VideoFrameBufferInit::getLayoutOr(const HeapVector<Member<PlaneLayout>>& fallback_value) const {
  if (!hasLayout()) {
  return fallback_value;
}
return member_layout_;
}

HeapVector<Member<PlaneLayout>> VideoFrameBufferInit::getLayoutOr(HeapVector<Member<PlaneLayout>>&& fallback_value) const {
  if (!hasLayout()) {
  return std::move(fallback_value);
}
return member_layout_;
}

void VideoFrameBufferInit::setLayout(const HeapVector<Member<PlaneLayout>>& value) {
  member_layout_ = value;
has_layout_ = true;
}

void VideoFrameBufferInit::setLayout(HeapVector<Member<PlaneLayout>>&& value) {
  member_layout_ = std::move(value);
has_layout_ = true;
}














void VideoFrameBufferInit::setTransfer(const HeapVector<Member<DOMArrayBuffer>>& value) {
  member_transfer_ = value;
}

void VideoFrameBufferInit::setTransfer(HeapVector<Member<DOMArrayBuffer>>&& value) {
  member_transfer_ = std::move(value);
}











void VideoFrameBufferInit::Trace(Visitor* visitor) const {
  visitor->Trace(member_color_space_);
visitor->Trace(member_layout_);
visitor->Trace(member_transfer_);
visitor->Trace(member_visible_rect_);
bindings::InputDictionaryBase::Trace(visitor);
}

void VideoFrameBufferInit::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "VideoFrameBufferInit";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("codedHeight");
constexpr bool is_required = true;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongEnforceRange, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_coded_height_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("codedWidth");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongEnforceRange, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_coded_width_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("colorSpace");
constexpr bool is_optional = false;
if (!bindings::GetDictionaryMemberFromV8Object<VideoColorSpaceInit, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_color_space_, member_color_space_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("displayHeight");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongEnforceRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_display_height_, member_display_height_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("displayWidth");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongEnforceRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_display_width_, member_display_width_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("duration");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLongEnforceRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_duration_, member_duration_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::WebCodecsOrientationEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("flip");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), fallback_presence_var, member_flip_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("format");
if (!bindings::GetDictionaryMemberFromV8Object<V8VideoPixelFormat, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), fallback_presence_var, member_format_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("layout");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<PlaneLayout>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_layout_, member_layout_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::WebCodecsOrientationEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("rotation");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), fallback_presence_var, member_rotation_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("timestamp");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLongLongEnforceRange, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[10].Get(isolate), fallback_presence_var, member_timestamp_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("transfer");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<DOMArrayBuffer>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[11].Get(isolate), fallback_presence_var, member_transfer_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("visibleRect");
if (!bindings::GetDictionaryMemberFromV8Object<DOMRectInit, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[12].Get(isolate), has_visible_rect_, member_visible_rect_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> VideoFrameBufferInit::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
