// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIDEO_ENCODER_ENCODE_OPTIONS_FOR_VP_9_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIDEO_ENCODER_ENCODE_OPTIONS_FOR_VP_9_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT VideoEncoderEncodeOptionsForVp9 : public bindings::InputDictionaryBase {
  
  public:
static VideoEncoderEncodeOptionsForVp9* Create() {
  return MakeGarbageCollected<VideoEncoderEncodeOptionsForVp9>();
}
static VideoEncoderEncodeOptionsForVp9* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<VideoEncoderEncodeOptionsForVp9>(isolate);
}
static VideoEncoderEncodeOptionsForVp9* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  VideoEncoderEncodeOptionsForVp9();
explicit  VideoEncoderEncodeOptionsForVp9(v8::Isolate* isolate);

bool hasQuantizer() const {
  return has_quantizer_;
}
uint16_t quantizer() const {
  DCHECK(hasQuantizer());
return member_quantizer_;
}
uint16_t getQuantizerOr(uint16_t fallback_value) const {
  if (!hasQuantizer()) {
  return fallback_value;
}
return member_quantizer_;
}
void setQuantizer(uint16_t value) {
  member_quantizer_ = value;
has_quantizer_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_quantizer_ = false;

uint16_t member_quantizer_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIDEO_ENCODER_ENCODE_OPTIONS_FOR_VP_9_H_
