// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_video_encoder_config.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_avc_encoder_config.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_hevc_encoder_config.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"alpha",
"avc",
"bitrate",
"bitrateMode",
"codec",
"contentHint",
"displayHeight",
"displayWidth",
"framerate",
"hardwareAcceleration",
"height",
"hevc",
"latencyMode",
"scalabilityMode",
"width",
};


}  // namespace 

VideoEncoderConfig* VideoEncoderConfig::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  VideoEncoderConfig* dictionary = MakeGarbageCollected<VideoEncoderConfig>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "VideoEncoderConfig";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 VideoEncoderConfig::VideoEncoderConfig() {
  
}

 VideoEncoderConfig::VideoEncoderConfig(v8::Isolate* isolate) {
  
}



























void VideoEncoderConfig::setCodec(const String& value) {
  member_codec_ = value;
}

void VideoEncoderConfig::setCodec(String&& value) {
  member_codec_ = std::move(value);
}




void VideoEncoderConfig::setContentHint(const String& value) {
  member_content_hint_ = value;
}

void VideoEncoderConfig::setContentHint(String&& value) {
  member_content_hint_ = std::move(value);
}















































String VideoEncoderConfig::getScalabilityModeOr(const String& fallback_value) const {
  if (!hasScalabilityMode()) {
  return fallback_value;
}
return member_scalability_mode_;
}

String VideoEncoderConfig::getScalabilityModeOr(String&& fallback_value) const {
  if (!hasScalabilityMode()) {
  return std::move(fallback_value);
}
return member_scalability_mode_;
}

void VideoEncoderConfig::setScalabilityMode(const String& value) {
  member_scalability_mode_ = value;
has_scalability_mode_ = true;
}

void VideoEncoderConfig::setScalabilityMode(String&& value) {
  member_scalability_mode_ = std::move(value);
has_scalability_mode_ = true;
}









void VideoEncoderConfig::Trace(Visitor* visitor) const {
  visitor->Trace(member_avc_);
visitor->Trace(member_hevc_);
bindings::DictionaryBase::Trace(visitor);
}

void VideoEncoderConfig::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void VideoEncoderConfig::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAlpha()) {
  values[0] = ToV8Traits<V8AlphaOption>::ToV8(script_state, member_alpha_);
DCHECK(!values[0].IsEmpty());
}
if (hasAvc()) {
  values[1] = ToV8Traits<AvcEncoderConfig>::ToV8(script_state, member_avc_.Get());
DCHECK(!values[1].IsEmpty());
}
if (hasBitrate()) {
  values[2] = ToV8Traits<IDLUnsignedLongLongEnforceRange>::ToV8(script_state, member_bitrate_);
DCHECK(!values[2].IsEmpty());
}
if (hasBitrateMode()) {
  values[3] = ToV8Traits<V8VideoEncoderBitrateMode>::ToV8(script_state, member_bitrate_mode_);
DCHECK(!values[3].IsEmpty());
}
if (hasCodec()) {
  values[4] = ToV8Traits<IDLString>::ToV8(script_state, member_codec_);
DCHECK(!values[4].IsEmpty());
}
if (hasContentHint()) {
  values[5] = ToV8Traits<IDLString>::ToV8(script_state, member_content_hint_);
DCHECK(!values[5].IsEmpty());
}
if (hasDisplayHeight()) {
  values[6] = ToV8Traits<IDLUnsignedLongEnforceRange>::ToV8(script_state, member_display_height_);
DCHECK(!values[6].IsEmpty());
}
if (hasDisplayWidth()) {
  values[7] = ToV8Traits<IDLUnsignedLongEnforceRange>::ToV8(script_state, member_display_width_);
DCHECK(!values[7].IsEmpty());
}
if (hasFramerate()) {
  values[8] = ToV8Traits<IDLDouble>::ToV8(script_state, member_framerate_);
DCHECK(!values[8].IsEmpty());
}
if (hasHardwareAcceleration()) {
  values[9] = ToV8Traits<V8HardwarePreference>::ToV8(script_state, member_hardware_acceleration_);
DCHECK(!values[9].IsEmpty());
}
if (hasHeight()) {
  values[10] = ToV8Traits<IDLUnsignedLongEnforceRange>::ToV8(script_state, member_height_);
DCHECK(!values[10].IsEmpty());
}
if (hasHevc()) {
  values[11] = ToV8Traits<HevcEncoderConfig>::ToV8(script_state, member_hevc_.Get());
DCHECK(!values[11].IsEmpty());
}
if (hasLatencyMode()) {
  values[12] = ToV8Traits<V8LatencyMode>::ToV8(script_state, member_latency_mode_);
DCHECK(!values[12].IsEmpty());
}
if (hasScalabilityMode()) {
  values[13] = ToV8Traits<IDLString>::ToV8(script_state, member_scalability_mode_);
DCHECK(!values[13].IsEmpty());
}
if (hasWidth()) {
  values[14] = ToV8Traits<IDLUnsignedLongEnforceRange>::ToV8(script_state, member_width_);
DCHECK(!values[14].IsEmpty());
}
}

const void* VideoEncoderConfig::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> VideoEncoderConfig::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void VideoEncoderConfig::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "VideoEncoderConfig";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("alpha");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<V8AlphaOption, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_alpha_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("avc");
if (!bindings::GetDictionaryMemberFromV8Object<AvcEncoderConfig, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_avc_, member_avc_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("bitrate");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLongEnforceRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_bitrate_, member_bitrate_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("bitrateMode");
if (!bindings::GetDictionaryMemberFromV8Object<V8VideoEncoderBitrateMode, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_bitrate_mode_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("codec");
constexpr bool is_required = true;
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), fallback_presence_var, member_codec_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("contentHint");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), fallback_presence_var, member_content_hint_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("displayHeight");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongEnforceRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_display_height_, member_display_height_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("displayWidth");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongEnforceRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_display_width_, member_display_width_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("framerate");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_framerate_, member_framerate_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("hardwareAcceleration");
if (!bindings::GetDictionaryMemberFromV8Object<V8HardwarePreference, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), fallback_presence_var, member_hardware_acceleration_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("height");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongEnforceRange, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[10].Get(isolate), fallback_presence_var, member_height_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("hevc");
if (!bindings::GetDictionaryMemberFromV8Object<HevcEncoderConfig, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[11].Get(isolate), has_hevc_, member_hevc_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("latencyMode");
if (!bindings::GetDictionaryMemberFromV8Object<V8LatencyMode, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[12].Get(isolate), fallback_presence_var, member_latency_mode_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("scalabilityMode");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[13].Get(isolate), has_scalability_mode_, member_scalability_mode_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("width");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongEnforceRange, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[14].Get(isolate), fallback_presence_var, member_width_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> VideoEncoderConfig::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
