// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_MEDIASTREAMTRACKAUDIOSTATS_MEDIASTREAMTRACKVIDEOSTATS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_MEDIASTREAMTRACKAUDIOSTATS_MEDIASTREAMTRACKVIDEOSTATS_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class MediaStreamTrackAudioStats;
class MediaStreamTrackVideoStats;
class ScriptState;

class MODULES_EXPORT V8UnionMediaStreamTrackAudioStatsOrMediaStreamTrackVideoStats final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kMediaStreamTrackAudioStats, kMediaStreamTrackVideoStats
};

static V8UnionMediaStreamTrackAudioStatsOrMediaStreamTrackVideoStats* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionMediaStreamTrackAudioStatsOrMediaStreamTrackVideoStats(MediaStreamTrackAudioStats* value) : content_type_(ContentType::kMediaStreamTrackAudioStats), member_media_stream_track_audio_stats_(value) {
  DCHECK(value);
}
explicit  V8UnionMediaStreamTrackAudioStatsOrMediaStreamTrackVideoStats(MediaStreamTrackVideoStats* value) : content_type_(ContentType::kMediaStreamTrackVideoStats), member_media_stream_track_video_stats_(value) {
  DCHECK(value);
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsMediaStreamTrackAudioStats() const {
  return content_type_ == ContentType::kMediaStreamTrackAudioStats;
}
MediaStreamTrackAudioStats* GetAsMediaStreamTrackAudioStats() const {
  DCHECK_EQ(content_type_, ContentType::kMediaStreamTrackAudioStats);
return member_media_stream_track_audio_stats_.Get();
}
void Set(MediaStreamTrackAudioStats* value) {
  DCHECK(value);
Clear();
member_media_stream_track_audio_stats_ = value;
content_type_ = ContentType::kMediaStreamTrackAudioStats;
}

bool IsMediaStreamTrackVideoStats() const {
  return content_type_ == ContentType::kMediaStreamTrackVideoStats;
}
MediaStreamTrackVideoStats* GetAsMediaStreamTrackVideoStats() const {
  DCHECK_EQ(content_type_, ContentType::kMediaStreamTrackVideoStats);
return member_media_stream_track_video_stats_.Get();
}
void Set(MediaStreamTrackVideoStats* value) {
  DCHECK(value);
Clear();
member_media_stream_track_video_stats_ = value;
content_type_ = ContentType::kMediaStreamTrackVideoStats;
}


v8::Local<v8::Value> ToV8(ScriptState* script_state) const;

void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(MediaStreamTrackAudioStats or MediaStreamTrackVideoStats)";
}

ContentType content_type_;

Member<MediaStreamTrackAudioStats> member_media_stream_track_audio_stats_;
Member<MediaStreamTrackVideoStats> member_media_stream_track_video_stats_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_MEDIASTREAMTRACKAUDIOSTATS_MEDIASTREAMTRACKVIDEOSTATS_H_
