// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_MEDIASOURCEHANDLE_MEDIASTREAM_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_MEDIASOURCEHANDLE_MEDIASTREAM_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class MediaSourceHandleImpl;
class MediaStream;
class ScriptState;

class MODULES_EXPORT V8UnionMediaSourceHandleOrMediaStream final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kMediaSourceHandle, kMediaStream
};

static V8UnionMediaSourceHandleOrMediaStream* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionMediaSourceHandleOrMediaStream(MediaSourceHandleImpl* value) : content_type_(ContentType::kMediaSourceHandle), member_media_source_handle_(value) {
  DCHECK(value);
}
explicit  V8UnionMediaSourceHandleOrMediaStream(MediaStream* value) : content_type_(ContentType::kMediaStream), member_media_stream_(value) {
  DCHECK(value);
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsMediaSourceHandle() const {
  return content_type_ == ContentType::kMediaSourceHandle;
}
MediaSourceHandleImpl* GetAsMediaSourceHandle() const {
  DCHECK_EQ(content_type_, ContentType::kMediaSourceHandle);
return member_media_source_handle_.Get();
}
void Set(MediaSourceHandleImpl* value) {
  DCHECK(value);
Clear();
member_media_source_handle_ = value;
content_type_ = ContentType::kMediaSourceHandle;
}

bool IsMediaStream() const {
  return content_type_ == ContentType::kMediaStream;
}
MediaStream* GetAsMediaStream() const {
  DCHECK_EQ(content_type_, ContentType::kMediaStream);
return member_media_stream_.Get();
}
void Set(MediaStream* value) {
  DCHECK(value);
Clear();
member_media_stream_ = value;
content_type_ = ContentType::kMediaStream;
}


v8::Local<v8::Value> ToV8(ScriptState* script_state) const;

void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(MediaSourceHandle or MediaStream)";
}

ContentType content_type_;

Member<MediaSourceHandleImpl> member_media_source_handle_;
Member<MediaStream> member_media_stream_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_MEDIASOURCEHANDLE_MEDIASTREAM_H_
