// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_udp_socket_options.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"dnsQueryType",
"ipv6Only",
"localAddress",
"localPort",
"multicastAllowAddressSharing",
"multicastLoopback",
"multicastTimeToLive",
"remoteAddress",
"remotePort",
};


}  // namespace 

UDPSocketOptions* UDPSocketOptions::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  UDPSocketOptions* dictionary = MakeGarbageCollected<UDPSocketOptions>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "UDPSocketOptions";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 UDPSocketOptions::UDPSocketOptions() {
  
}

 UDPSocketOptions::UDPSocketOptions(v8::Isolate* isolate) : SocketOptions(isolate) {
  
}

















String UDPSocketOptions::getLocalAddressOr(const String& fallback_value) const {
  if (!hasLocalAddress()) {
  return fallback_value;
}
return member_local_address_;
}

String UDPSocketOptions::getLocalAddressOr(String&& fallback_value) const {
  if (!hasLocalAddress()) {
  return std::move(fallback_value);
}
return member_local_address_;
}

void UDPSocketOptions::setLocalAddress(const String& value) {
  member_local_address_ = value;
has_local_address_ = true;
}

void UDPSocketOptions::setLocalAddress(String&& value) {
  member_local_address_ = std::move(value);
has_local_address_ = true;
}
































String UDPSocketOptions::getRemoteAddressOr(const String& fallback_value) const {
  if (!hasRemoteAddress()) {
  return fallback_value;
}
return member_remote_address_;
}

String UDPSocketOptions::getRemoteAddressOr(String&& fallback_value) const {
  if (!hasRemoteAddress()) {
  return std::move(fallback_value);
}
return member_remote_address_;
}

void UDPSocketOptions::setRemoteAddress(const String& value) {
  member_remote_address_ = value;
has_remote_address_ = true;
}

void UDPSocketOptions::setRemoteAddress(String&& value) {
  member_remote_address_ = std::move(value);
has_remote_address_ = true;
}











void UDPSocketOptions::Trace(Visitor* visitor) const {
  SocketOptions::Trace(visitor);
}

void UDPSocketOptions::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
SocketOptions::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "UDPSocketOptions";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("dnsQueryType");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<V8SocketDnsQueryType, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_dns_query_type_, member_dns_query_type_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("ipv6Only");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_ipv_6_only_, member_ipv_6_only_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("localAddress");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_local_address_, member_local_address_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("localPort");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedShortEnforceRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_local_port_, member_local_port_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::MulticastInDirectSocketsEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("multicastAllowAddressSharing");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_multicast_allow_address_sharing_, member_multicast_allow_address_sharing_, class_like_name, exception_state)) {
  return;
}
}
if (RuntimeEnabledFeatures::MulticastInDirectSocketsEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("multicastLoopback");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_multicast_loopback_, member_multicast_loopback_, class_like_name, exception_state)) {
  return;
}
}
if (RuntimeEnabledFeatures::MulticastInDirectSocketsEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("multicastTimeToLive");
if (!bindings::GetDictionaryMemberFromV8Object<IDLOctetEnforceRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_multicast_time_to_live_, member_multicast_time_to_live_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("remoteAddress");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_remote_address_, member_remote_address_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("remotePort");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedShortEnforceRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_remote_port_, member_remote_port_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> UDPSocketOptions::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
