// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_TEXT_ENCODER_ENCODE_INTO_RESULT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_TEXT_ENCODER_ENCODE_INTO_RESULT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT TextEncoderEncodeIntoResult : public bindings::DictionaryBase {
  
  public:
static TextEncoderEncodeIntoResult* Create() {
  return MakeGarbageCollected<TextEncoderEncodeIntoResult>();
}
static TextEncoderEncodeIntoResult* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<TextEncoderEncodeIntoResult>(isolate);
}
static TextEncoderEncodeIntoResult* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  TextEncoderEncodeIntoResult();
explicit  TextEncoderEncodeIntoResult(v8::Isolate* isolate);

bool hasRead() const {
  return has_read_;
}
uint64_t read() const {
  DCHECK(hasRead());
return member_read_;
}
uint64_t getReadOr(uint64_t fallback_value) const {
  if (!hasRead()) {
  return fallback_value;
}
return member_read_;
}
void setRead(uint64_t value) {
  member_read_ = value;
has_read_ = true;
}

bool hasWritten() const {
  return has_written_;
}
uint64_t written() const {
  DCHECK(hasWritten());
return member_written_;
}
uint64_t getWrittenOr(uint64_t fallback_value) const {
  if (!hasWritten()) {
  return fallback_value;
}
return member_written_;
}
void setWritten(uint64_t value) {
  member_written_ = value;
has_written_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_read_ = false;
bool has_written_ = false;

uint64_t member_read_;
uint64_t member_written_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_TEXT_ENCODER_ENCODE_INTO_RESULT_H_
