// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SVC_OUTPUT_METADATA_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SVC_OUTPUT_METADATA_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT SvcOutputMetadata : public bindings::DictionaryBase {
  
  public:
static SvcOutputMetadata* Create() {
  return MakeGarbageCollected<SvcOutputMetadata>();
}
static SvcOutputMetadata* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<SvcOutputMetadata>(isolate);
}
static SvcOutputMetadata* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  SvcOutputMetadata();
explicit  SvcOutputMetadata(v8::Isolate* isolate);

bool hasTemporalLayerId() const {
  return has_temporal_layer_id_;
}
uint32_t temporalLayerId() const {
  DCHECK(hasTemporalLayerId());
return member_temporal_layer_id_;
}
uint32_t getTemporalLayerIdOr(uint32_t fallback_value) const {
  if (!hasTemporalLayerId()) {
  return fallback_value;
}
return member_temporal_layer_id_;
}
void setTemporalLayerId(uint32_t value) {
  member_temporal_layer_id_ = value;
has_temporal_layer_id_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_temporal_layer_id_ = false;

uint32_t member_temporal_layer_id_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SVC_OUTPUT_METADATA_H_
