// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_STORAGE_ESTIMATE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_STORAGE_ESTIMATE_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class StorageUsageDetails;

class MODULES_EXPORT StorageEstimate : public bindings::DictionaryBase {
  
  public:
static StorageEstimate* Create() {
  return MakeGarbageCollected<StorageEstimate>();
}
static StorageEstimate* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<StorageEstimate>(isolate);
}
static StorageEstimate* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  StorageEstimate();
explicit  StorageEstimate(v8::Isolate* isolate);

bool hasQuota() const {
  return has_quota_;
}
uint64_t quota() const {
  DCHECK(hasQuota());
return member_quota_;
}
uint64_t getQuotaOr(uint64_t fallback_value) const {
  if (!hasQuota()) {
  return fallback_value;
}
return member_quota_;
}
void setQuota(uint64_t value) {
  member_quota_ = value;
has_quota_ = true;
}

bool hasUsage() const {
  return has_usage_;
}
uint64_t usage() const {
  DCHECK(hasUsage());
return member_usage_;
}
uint64_t getUsageOr(uint64_t fallback_value) const {
  if (!hasUsage()) {
  return fallback_value;
}
return member_usage_;
}
void setUsage(uint64_t value) {
  member_usage_ = value;
has_usage_ = true;
}

bool hasUsageDetails() const {
  return has_usage_details_;
}
StorageUsageDetails* usageDetails() const {
  DCHECK(hasUsageDetails());
return member_usage_details_.Get();
}
StorageUsageDetails* getUsageDetailsOr(StorageUsageDetails* fallback_value) const {
  if (!hasUsageDetails()) {
  return fallback_value;
}
return member_usage_details_.Get();
}
void setUsageDetails(StorageUsageDetails* value) {
  member_usage_details_ = value;
has_usage_details_ = true;
DCHECK(member_usage_details_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_quota_ = false;
bool has_usage_ = false;
bool has_usage_details_ = false;

uint64_t member_quota_;
uint64_t member_usage_;
Member<StorageUsageDetails> member_usage_details_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_STORAGE_ESTIMATE_H_
