// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_speech_recognition_error_event_init.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"error",
"message",
};


}  // namespace 

SpeechRecognitionErrorEventInit* SpeechRecognitionErrorEventInit::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  SpeechRecognitionErrorEventInit* dictionary = MakeGarbageCollected<SpeechRecognitionErrorEventInit>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "SpeechRecognitionErrorEventInit";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 SpeechRecognitionErrorEventInit::SpeechRecognitionErrorEventInit() {
  
}

 SpeechRecognitionErrorEventInit::SpeechRecognitionErrorEventInit(v8::Isolate* isolate) : EventInit(isolate) {
  
}



String SpeechRecognitionErrorEventInit::getErrorOr(const String& fallback_value) const {
  if (!hasError()) {
  return fallback_value;
}
return member_error_;
}

String SpeechRecognitionErrorEventInit::getErrorOr(String&& fallback_value) const {
  if (!hasError()) {
  return std::move(fallback_value);
}
return member_error_;
}

void SpeechRecognitionErrorEventInit::setError(const String& value) {
  member_error_ = value;
has_error_ = true;
}

void SpeechRecognitionErrorEventInit::setError(String&& value) {
  member_error_ = std::move(value);
has_error_ = true;
}




String SpeechRecognitionErrorEventInit::getMessageOr(const String& fallback_value) const {
  if (!hasMessage()) {
  return fallback_value;
}
return member_message_;
}

String SpeechRecognitionErrorEventInit::getMessageOr(String&& fallback_value) const {
  if (!hasMessage()) {
  return std::move(fallback_value);
}
return member_message_;
}

void SpeechRecognitionErrorEventInit::setMessage(const String& value) {
  member_message_ = value;
has_message_ = true;
}

void SpeechRecognitionErrorEventInit::setMessage(String&& value) {
  member_message_ = std::move(value);
has_message_ = true;
}




void SpeechRecognitionErrorEventInit::Trace(Visitor* visitor) const {
  EventInit::Trace(visitor);
}

void SpeechRecognitionErrorEventInit::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
EventInit::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "SpeechRecognitionErrorEventInit";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("error");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_error_, member_error_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("message");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_message_, member_message_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> SpeechRecognitionErrorEventInit::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
