// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SOURCE_BUFFER_CONFIG_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SOURCE_BUFFER_CONFIG_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class AudioDecoderConfig;
class ExceptionState;
class VideoDecoderConfig;

class MODULES_EXPORT SourceBufferConfig : public bindings::InputDictionaryBase {
  
  public:
static SourceBufferConfig* Create() {
  return MakeGarbageCollected<SourceBufferConfig>();
}
static SourceBufferConfig* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<SourceBufferConfig>(isolate);
}
static SourceBufferConfig* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  SourceBufferConfig();
explicit  SourceBufferConfig(v8::Isolate* isolate);

bool hasAudioConfig() const {
  return has_audio_config_;
}
AudioDecoderConfig* audioConfig() const {
  DCHECK(hasAudioConfig());
return member_audio_config_.Get();
}
AudioDecoderConfig* getAudioConfigOr(AudioDecoderConfig* fallback_value) const {
  if (!hasAudioConfig()) {
  return fallback_value;
}
return member_audio_config_.Get();
}
void setAudioConfig(AudioDecoderConfig* value) {
  member_audio_config_ = value;
has_audio_config_ = true;
DCHECK(member_audio_config_);
}

bool hasVideoConfig() const {
  return has_video_config_;
}
VideoDecoderConfig* videoConfig() const {
  DCHECK(hasVideoConfig());
return member_video_config_.Get();
}
VideoDecoderConfig* getVideoConfigOr(VideoDecoderConfig* fallback_value) const {
  if (!hasVideoConfig()) {
  return fallback_value;
}
return member_video_config_.Get();
}
void setVideoConfig(VideoDecoderConfig* value) {
  member_video_config_ = value;
has_video_config_ = true;
DCHECK(member_video_config_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_audio_config_ = false;
bool has_video_config_ = false;

Member<AudioDecoderConfig> member_audio_config_;
Member<VideoDecoderConfig> member_video_config_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SOURCE_BUFFER_CONFIG_H_
