// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SHARED_STORAGE_WORKLET_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SHARED_STORAGE_WORKLET_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_worklet_options.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT SharedStorageWorkletOptions : public WorkletOptions {
  
  public:
static SharedStorageWorkletOptions* Create() {
  return MakeGarbageCollected<SharedStorageWorkletOptions>();
}
static SharedStorageWorkletOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<SharedStorageWorkletOptions>(isolate);
}
static SharedStorageWorkletOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  SharedStorageWorkletOptions();
explicit  SharedStorageWorkletOptions(v8::Isolate* isolate);

bool hasDataOrigin() const {
  return true;
}
const String& dataOrigin() const {
  return member_data_origin_;
}
void setDataOrigin(const String& value);
void setDataOrigin(String&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = WorkletOptions::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



String member_data_origin_{"context-origin"};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SHARED_STORAGE_WORKLET_OPTIONS_H_
