// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SERIAL_PORT_REQUEST_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SERIAL_PORT_REQUEST_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class SerialPortFilter;
class V8UnionStringOrUnsignedLong;

class MODULES_EXPORT SerialPortRequestOptions : public bindings::InputDictionaryBase {
  
  public:
static SerialPortRequestOptions* Create() {
  return MakeGarbageCollected<SerialPortRequestOptions>();
}
static SerialPortRequestOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<SerialPortRequestOptions>(isolate);
}
static SerialPortRequestOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  SerialPortRequestOptions();
explicit  SerialPortRequestOptions(v8::Isolate* isolate);

bool hasAllowedBluetoothServiceClassIds() const {
  return has_allowed_bluetooth_service_class_ids_;
}
const HeapVector<Member<V8UnionStringOrUnsignedLong>>& allowedBluetoothServiceClassIds() const {
  DCHECK(hasAllowedBluetoothServiceClassIds());
return member_allowed_bluetooth_service_class_ids_;
}
HeapVector<Member<V8UnionStringOrUnsignedLong>> getAllowedBluetoothServiceClassIdsOr(const HeapVector<Member<V8UnionStringOrUnsignedLong>>& fallback_value) const;
HeapVector<Member<V8UnionStringOrUnsignedLong>> getAllowedBluetoothServiceClassIdsOr(HeapVector<Member<V8UnionStringOrUnsignedLong>>&& fallback_value) const;
void setAllowedBluetoothServiceClassIds(const HeapVector<Member<V8UnionStringOrUnsignedLong>>& value);
void setAllowedBluetoothServiceClassIds(HeapVector<Member<V8UnionStringOrUnsignedLong>>&& value);

bool hasFilters() const {
  return has_filters_;
}
const HeapVector<Member<SerialPortFilter>>& filters() const {
  DCHECK(hasFilters());
return member_filters_;
}
HeapVector<Member<SerialPortFilter>> getFiltersOr(const HeapVector<Member<SerialPortFilter>>& fallback_value) const;
HeapVector<Member<SerialPortFilter>> getFiltersOr(HeapVector<Member<SerialPortFilter>>&& fallback_value) const;
void setFilters(const HeapVector<Member<SerialPortFilter>>& value);
void setFilters(HeapVector<Member<SerialPortFilter>>&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_allowed_bluetooth_service_class_ids_ = false;
bool has_filters_ = false;

HeapVector<Member<V8UnionStringOrUnsignedLong>> member_allowed_bluetooth_service_class_ids_;
HeapVector<Member<SerialPortFilter>> member_filters_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SERIAL_PORT_REQUEST_OPTIONS_H_
