// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SERIAL_INPUT_SIGNALS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SERIAL_INPUT_SIGNALS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT SerialInputSignals : public bindings::DictionaryBase {
  
  public:
static SerialInputSignals* Create() {
  return MakeGarbageCollected<SerialInputSignals>();
}
static SerialInputSignals* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<SerialInputSignals>(isolate);
}
static SerialInputSignals* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  SerialInputSignals();
explicit  SerialInputSignals(v8::Isolate* isolate);

bool hasClearToSend() const {
  return true;
}
bool clearToSend() const {
  return member_clear_to_send_;
}
void setClearToSend(bool value) {
  member_clear_to_send_ = value;
}

bool hasDataCarrierDetect() const {
  return true;
}
bool dataCarrierDetect() const {
  return member_data_carrier_detect_;
}
void setDataCarrierDetect(bool value) {
  member_data_carrier_detect_ = value;
}

bool hasDataSetReady() const {
  return true;
}
bool dataSetReady() const {
  return member_data_set_ready_;
}
void setDataSetReady(bool value) {
  member_data_set_ready_ = value;
}

bool hasRingIndicator() const {
  return true;
}
bool ringIndicator() const {
  return member_ring_indicator_;
}
void setRingIndicator(bool value) {
  member_ring_indicator_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



bool member_clear_to_send_;
bool member_data_carrier_detect_;
bool member_data_set_ready_;
bool member_ring_indicator_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SERIAL_INPUT_SIGNALS_H_
