// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_VIDEO_SOURCE_STATS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_VIDEO_SOURCE_STATS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_media_source_stats.h"
#include "third_party/blink/renderer/modules/modules_export.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT RTCVideoSourceStats : public RTCMediaSourceStats {
  
  public:
static RTCVideoSourceStats* Create() {
  return MakeGarbageCollected<RTCVideoSourceStats>();
}
static RTCVideoSourceStats* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCVideoSourceStats>(isolate);
}
static RTCVideoSourceStats* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCVideoSourceStats();
explicit  RTCVideoSourceStats(v8::Isolate* isolate);

bool hasFrames() const {
  return has_frames_;
}
uint32_t frames() const {
  DCHECK(hasFrames());
return member_frames_;
}
uint32_t getFramesOr(uint32_t fallback_value) const {
  if (!hasFrames()) {
  return fallback_value;
}
return member_frames_;
}
void setFrames(uint32_t value) {
  member_frames_ = value;
has_frames_ = true;
}

bool hasFramesPerSecond() const {
  return has_frames_per_second_;
}
double framesPerSecond() const {
  DCHECK(hasFramesPerSecond());
return member_frames_per_second_;
}
double getFramesPerSecondOr(double fallback_value) const {
  if (!hasFramesPerSecond()) {
  return fallback_value;
}
return member_frames_per_second_;
}
void setFramesPerSecond(double value) {
  member_frames_per_second_ = value;
has_frames_per_second_ = true;
}

bool hasHeight() const {
  return has_height_;
}
uint32_t height() const {
  DCHECK(hasHeight());
return member_height_;
}
uint32_t getHeightOr(uint32_t fallback_value) const {
  if (!hasHeight()) {
  return fallback_value;
}
return member_height_;
}
void setHeight(uint32_t value) {
  member_height_ = value;
has_height_ = true;
}

bool hasWidth() const {
  return has_width_;
}
uint32_t width() const {
  DCHECK(hasWidth());
return member_width_;
}
uint32_t getWidthOr(uint32_t fallback_value) const {
  if (!hasWidth()) {
  return fallback_value;
}
return member_width_;
}
void setWidth(uint32_t value) {
  member_width_ = value;
has_width_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = RTCMediaSourceStats::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_frames_ = false;
bool has_frames_per_second_ = false;
bool has_height_ = false;
bool has_width_ = false;

uint32_t member_frames_;
double member_frames_per_second_;
uint32_t member_height_;
uint32_t member_width_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_VIDEO_SOURCE_STATS_H_
