// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_TRACK_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_TRACK_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_init.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class MediaStream;
class MediaStreamTrack;
class RTCRtpReceiver;
class RTCRtpTransceiver;

class MODULES_EXPORT RTCTrackEventInit : public EventInit {
  
  public:
static RTCTrackEventInit* Create() {
  return MakeGarbageCollected<RTCTrackEventInit>();
}
static RTCTrackEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCTrackEventInit>(isolate);
}
static RTCTrackEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCTrackEventInit();
explicit  RTCTrackEventInit(v8::Isolate* isolate);

bool hasReceiver() const {
  return true;
}
RTCRtpReceiver* receiver() const {
  return member_receiver_.Get();
}
void setReceiver(RTCRtpReceiver* value) {
  member_receiver_ = value;
DCHECK(member_receiver_);
}

bool hasStreams() const {
  return true;
}
const HeapVector<Member<MediaStream>>& streams() const {
  return member_streams_;
}
void setStreams(const HeapVector<Member<MediaStream>>& value);
void setStreams(HeapVector<Member<MediaStream>>&& value);

bool hasTrack() const {
  return true;
}
MediaStreamTrack* track() const {
  return member_track_.Get();
}
void setTrack(MediaStreamTrack* value) {
  member_track_ = value;
DCHECK(member_track_);
}

bool hasTransceiver() const {
  return true;
}
RTCRtpTransceiver* transceiver() const {
  return member_transceiver_.Get();
}
void setTransceiver(RTCRtpTransceiver* value) {
  member_transceiver_ = value;
DCHECK(member_transceiver_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



Member<RTCRtpReceiver> member_receiver_;
HeapVector<Member<MediaStream>> member_streams_;
Member<MediaStreamTrack> member_track_;
Member<RTCRtpTransceiver> member_transceiver_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_TRACK_EVENT_INIT_H_
