// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_SEND_PACKET_PARAMETERS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_SEND_PACKET_PARAMETERS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT RtcSendPacketParameters : public bindings::InputDictionaryBase {
  
  public:
static RtcSendPacketParameters* Create() {
  return MakeGarbageCollected<RtcSendPacketParameters>();
}
static RtcSendPacketParameters* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RtcSendPacketParameters>(isolate);
}
static RtcSendPacketParameters* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RtcSendPacketParameters();
explicit  RtcSendPacketParameters(v8::Isolate* isolate);

bool hasData() const {
  return has_data_;
}
DOMArrayBuffer* data() const {
  DCHECK(hasData());
return member_data_.Get();
}
DOMArrayBuffer* getDataOr(DOMArrayBuffer* fallback_value) const {
  if (!hasData()) {
  return fallback_value;
}
return member_data_.Get();
}
void setData(DOMArrayBuffer* value) {
  member_data_ = value;
has_data_ = true;
DCHECK(member_data_);
}

bool hasDesiredSendTime() const {
  return has_desired_send_time_;
}
double desiredSendTime() const {
  DCHECK(hasDesiredSendTime());
return member_desired_send_time_;
}
double getDesiredSendTimeOr(double fallback_value) const {
  if (!hasDesiredSendTime()) {
  return fallback_value;
}
return member_desired_send_time_;
}
void setDesiredSendTime(double value) {
  member_desired_send_time_ = value;
has_desired_send_time_ = true;
}

bool hasId() const {
  return has_id_;
}
int64_t id() const {
  DCHECK(hasId());
return member_id_;
}
int64_t getIdOr(int64_t fallback_value) const {
  if (!hasId()) {
  return fallback_value;
}
return member_id_;
}
void setId(int64_t value) {
  member_id_ = value;
has_id_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_data_ = false;
bool has_desired_send_time_ = false;
bool has_id_ = false;

Member<DOMArrayBuffer> member_data_;
double member_desired_send_time_;
int64_t member_id_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_SEND_PACKET_PARAMETERS_H_
