// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_rtp_parameters.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_rtcp_parameters.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_rtp_codec_parameters.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_rtp_header_extension_parameters.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"codecs",
"headerExtensions",
"rtcp",
};


}  // namespace 

RTCRtpParameters* RTCRtpParameters::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  RTCRtpParameters* dictionary = MakeGarbageCollected<RTCRtpParameters>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "RTCRtpParameters";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 RTCRtpParameters::RTCRtpParameters() {
  
}

 RTCRtpParameters::RTCRtpParameters(v8::Isolate* isolate) {
  
}



void RTCRtpParameters::setCodecs(const HeapVector<Member<RTCRtpCodecParameters>>& value) {
  member_codecs_ = value;
}

void RTCRtpParameters::setCodecs(HeapVector<Member<RTCRtpCodecParameters>>&& value) {
  member_codecs_ = std::move(value);
}




void RTCRtpParameters::setHeaderExtensions(const HeapVector<Member<RTCRtpHeaderExtensionParameters>>& value) {
  member_header_extensions_ = value;
}

void RTCRtpParameters::setHeaderExtensions(HeapVector<Member<RTCRtpHeaderExtensionParameters>>&& value) {
  member_header_extensions_ = std::move(value);
}









void RTCRtpParameters::Trace(Visitor* visitor) const {
  visitor->Trace(member_codecs_);
visitor->Trace(member_header_extensions_);
visitor->Trace(member_rtcp_);
bindings::DictionaryBase::Trace(visitor);
}

void RTCRtpParameters::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void RTCRtpParameters::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasCodecs()) {
  values[0] = ToV8Traits<IDLSequence<RTCRtpCodecParameters>>::ToV8(script_state, member_codecs_);
DCHECK(!values[0].IsEmpty());
}
if (hasHeaderExtensions()) {
  values[1] = ToV8Traits<IDLSequence<RTCRtpHeaderExtensionParameters>>::ToV8(script_state, member_header_extensions_);
DCHECK(!values[1].IsEmpty());
}
if (hasRtcp()) {
  values[2] = ToV8Traits<RTCRtcpParameters>::ToV8(script_state, member_rtcp_.Get());
DCHECK(!values[2].IsEmpty());
}
}

const void* RTCRtpParameters::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> RTCRtpParameters::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void RTCRtpParameters::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "RTCRtpParameters";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("codecs");
constexpr bool is_required = true;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<RTCRtpCodecParameters>, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_codecs_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("headerExtensions");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<RTCRtpHeaderExtensionParameters>, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_header_extensions_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("rtcp");
if (!bindings::GetDictionaryMemberFromV8Object<RTCRtcpParameters, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_rtcp_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> RTCRtpParameters::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
