// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_RTP_ENCODING_PARAMETERS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_RTP_ENCODING_PARAMETERS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_priority_type.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_rtp_coding_parameters.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class RTCResolutionRestriction;
class RTCRtpCodec;

class MODULES_EXPORT RTCRtpEncodingParameters : public RTCRtpCodingParameters {
  
  public:
static RTCRtpEncodingParameters* Create() {
  return MakeGarbageCollected<RTCRtpEncodingParameters>();
}
static RTCRtpEncodingParameters* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCRtpEncodingParameters>(isolate);
}
static RTCRtpEncodingParameters* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCRtpEncodingParameters();
explicit  RTCRtpEncodingParameters(v8::Isolate* isolate);

bool hasActive() const {
  return true;
}
bool active() const {
  return member_active_;
}
void setActive(bool value) {
  member_active_ = value;
}

bool hasAdaptivePtime() const {
  return true;
}
bool adaptivePtime() const {
  return member_adaptive_ptime_;
}
void setAdaptivePtime(bool value) {
  member_adaptive_ptime_ = value;
}

bool hasCodec() const {
  return has_codec_;
}
RTCRtpCodec* codec() const {
  DCHECK(hasCodec());
return member_codec_.Get();
}
RTCRtpCodec* getCodecOr(RTCRtpCodec* fallback_value) const {
  if (!hasCodec()) {
  return fallback_value;
}
return member_codec_.Get();
}
void setCodec(RTCRtpCodec* value) {
  member_codec_ = value;
has_codec_ = true;
DCHECK(member_codec_);
}

bool hasMaxBitrate() const {
  return has_max_bitrate_;
}
uint32_t maxBitrate() const {
  DCHECK(hasMaxBitrate());
return member_max_bitrate_;
}
uint32_t getMaxBitrateOr(uint32_t fallback_value) const {
  if (!hasMaxBitrate()) {
  return fallback_value;
}
return member_max_bitrate_;
}
void setMaxBitrate(uint32_t value) {
  member_max_bitrate_ = value;
has_max_bitrate_ = true;
}

bool hasMaxFramerate() const {
  return has_max_framerate_;
}
double maxFramerate() const {
  DCHECK(hasMaxFramerate());
return member_max_framerate_;
}
double getMaxFramerateOr(double fallback_value) const {
  if (!hasMaxFramerate()) {
  return fallback_value;
}
return member_max_framerate_;
}
void setMaxFramerate(double value) {
  member_max_framerate_ = value;
has_max_framerate_ = true;
}

bool hasNetworkPriority() const {
  return true;
}
V8RTCPriorityType networkPriority() const {
  return member_network_priority_;
}
void setNetworkPriority(V8RTCPriorityType value) {
  member_network_priority_ = value;
}
void setNetworkPriority(V8RTCPriorityType::Enum value) {
  member_network_priority_ = V8RTCPriorityType(value);
}

bool hasPriority() const {
  return true;
}
V8RTCPriorityType priority() const {
  return member_priority_;
}
void setPriority(V8RTCPriorityType value) {
  member_priority_ = value;
}
void setPriority(V8RTCPriorityType::Enum value) {
  member_priority_ = V8RTCPriorityType(value);
}

bool hasScalabilityMode() const {
  return has_scalability_mode_;
}
const String& scalabilityMode() const {
  DCHECK(hasScalabilityMode());
return member_scalability_mode_;
}
String getScalabilityModeOr(const String& fallback_value) const;
String getScalabilityModeOr(String&& fallback_value) const;
void setScalabilityMode(const String& value);
void setScalabilityMode(String&& value);

bool hasScaleResolutionDownBy() const {
  return has_scale_resolution_down_by_;
}
double scaleResolutionDownBy() const {
  DCHECK(hasScaleResolutionDownBy());
return member_scale_resolution_down_by_;
}
double getScaleResolutionDownByOr(double fallback_value) const {
  if (!hasScaleResolutionDownBy()) {
  return fallback_value;
}
return member_scale_resolution_down_by_;
}
void setScaleResolutionDownBy(double value) {
  member_scale_resolution_down_by_ = value;
has_scale_resolution_down_by_ = true;
}

bool hasScaleResolutionDownTo() const {
  return has_scale_resolution_down_to_;
}
RTCResolutionRestriction* scaleResolutionDownTo() const {
  DCHECK(hasScaleResolutionDownTo());
return member_scale_resolution_down_to_.Get();
}
RTCResolutionRestriction* getScaleResolutionDownToOr(RTCResolutionRestriction* fallback_value) const {
  if (!hasScaleResolutionDownTo()) {
  return fallback_value;
}
return member_scale_resolution_down_to_.Get();
}
void setScaleResolutionDownTo(RTCResolutionRestriction* value) {
  member_scale_resolution_down_to_ = value;
has_scale_resolution_down_to_ = true;
DCHECK(member_scale_resolution_down_to_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = RTCRtpCodingParameters::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 10;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_codec_ = false;
bool has_max_bitrate_ = false;
bool has_max_framerate_ = false;
bool has_scalability_mode_ = false;
bool has_scale_resolution_down_by_ = false;
bool has_scale_resolution_down_to_ = false;

bool member_active_{true};
bool member_adaptive_ptime_{false};
Member<RTCRtpCodec> member_codec_;
uint32_t member_max_bitrate_;
double member_max_framerate_;
V8RTCPriorityType member_network_priority_{V8RTCPriorityType::Enum::kLow};
V8RTCPriorityType member_priority_{V8RTCPriorityType::Enum::kLow};
String member_scalability_mode_;
double member_scale_resolution_down_by_;
Member<RTCResolutionRestriction> member_scale_resolution_down_to_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_RTP_ENCODING_PARAMETERS_H_
