// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_rtp_encoding_parameters.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_resolution_restriction.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_rtp_codec.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"active",
"adaptivePtime",
"codec",
"maxBitrate",
"maxFramerate",
"networkPriority",
"priority",
"scalabilityMode",
"scaleResolutionDownBy",
"scaleResolutionDownTo",
};


}  // namespace 

RTCRtpEncodingParameters* RTCRtpEncodingParameters::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  RTCRtpEncodingParameters* dictionary = MakeGarbageCollected<RTCRtpEncodingParameters>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "RTCRtpEncodingParameters";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 RTCRtpEncodingParameters::RTCRtpEncodingParameters() {
  
}

 RTCRtpEncodingParameters::RTCRtpEncodingParameters(v8::Isolate* isolate) : RTCRtpCodingParameters(isolate) {
  
}












































String RTCRtpEncodingParameters::getScalabilityModeOr(const String& fallback_value) const {
  if (!hasScalabilityMode()) {
  return fallback_value;
}
return member_scalability_mode_;
}

String RTCRtpEncodingParameters::getScalabilityModeOr(String&& fallback_value) const {
  if (!hasScalabilityMode()) {
  return std::move(fallback_value);
}
return member_scalability_mode_;
}

void RTCRtpEncodingParameters::setScalabilityMode(const String& value) {
  member_scalability_mode_ = value;
has_scalability_mode_ = true;
}

void RTCRtpEncodingParameters::setScalabilityMode(String&& value) {
  member_scalability_mode_ = std::move(value);
has_scalability_mode_ = true;
}


















void RTCRtpEncodingParameters::Trace(Visitor* visitor) const {
  visitor->Trace(member_codec_);
visitor->Trace(member_scale_resolution_down_to_);
RTCRtpCodingParameters::Trace(visitor);
}

void RTCRtpEncodingParameters::FillTemplateProperties(Vector<std::string_view>& properties) const {
  RTCRtpCodingParameters::FillTemplateProperties(properties);
DCHECK_EQ(properties.size(), kBasePropertyCount);

static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void RTCRtpEncodingParameters::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  RTCRtpCodingParameters::FillValuesImpl(script_state, values.first(kBasePropertyCount));
values = values.subspan(kBasePropertyCount);

CHECK_EQ(kOwnPropertyCount, values.size());
if (hasActive()) {
  values[0] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_active_);
DCHECK(!values[0].IsEmpty());
}
if (hasAdaptivePtime()) {
  values[1] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_adaptive_ptime_);
DCHECK(!values[1].IsEmpty());
}
if (RuntimeEnabledFeatures::RTCRtpEncodingParametersCodecEnabled()) {
  if (hasCodec()) {
  values[2] = ToV8Traits<RTCRtpCodec>::ToV8(script_state, member_codec_.Get());
DCHECK(!values[2].IsEmpty());
}
}
if (hasMaxBitrate()) {
  values[3] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_max_bitrate_);
DCHECK(!values[3].IsEmpty());
}
if (hasMaxFramerate()) {
  values[4] = ToV8Traits<IDLDouble>::ToV8(script_state, member_max_framerate_);
DCHECK(!values[4].IsEmpty());
}
if (hasNetworkPriority()) {
  values[5] = ToV8Traits<V8RTCPriorityType>::ToV8(script_state, member_network_priority_);
DCHECK(!values[5].IsEmpty());
}
if (hasPriority()) {
  values[6] = ToV8Traits<V8RTCPriorityType>::ToV8(script_state, member_priority_);
DCHECK(!values[6].IsEmpty());
}
if (RuntimeEnabledFeatures::RTCSvcScalabilityModeEnabled()) {
  if (hasScalabilityMode()) {
  values[7] = ToV8Traits<IDLString>::ToV8(script_state, member_scalability_mode_);
DCHECK(!values[7].IsEmpty());
}
}
if (hasScaleResolutionDownBy()) {
  values[8] = ToV8Traits<IDLDouble>::ToV8(script_state, member_scale_resolution_down_by_);
DCHECK(!values[8].IsEmpty());
}
if (RuntimeEnabledFeatures::RTCRtpScaleResolutionDownToEnabled()) {
  if (hasScaleResolutionDownTo()) {
  values[9] = ToV8Traits<RTCResolutionRestriction>::ToV8(script_state, member_scale_resolution_down_to_.Get());
DCHECK(!values[9].IsEmpty());
}
}
}

const void* RTCRtpEncodingParameters::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> RTCRtpEncodingParameters::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void RTCRtpEncodingParameters::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
RTCRtpCodingParameters::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "RTCRtpEncodingParameters";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("active");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_active_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("adaptivePtime");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_adaptive_ptime_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::RTCRtpEncodingParametersCodecEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("codec");
if (!bindings::GetDictionaryMemberFromV8Object<RTCRtpCodec, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_codec_, member_codec_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("maxBitrate");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_max_bitrate_, member_max_bitrate_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("maxFramerate");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_max_framerate_, member_max_framerate_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("networkPriority");
if (!bindings::GetDictionaryMemberFromV8Object<V8RTCPriorityType, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), fallback_presence_var, member_network_priority_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("priority");
if (!bindings::GetDictionaryMemberFromV8Object<V8RTCPriorityType, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), fallback_presence_var, member_priority_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::RTCSvcScalabilityModeEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("scalabilityMode");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_scalability_mode_, member_scalability_mode_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("scaleResolutionDownBy");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_scale_resolution_down_by_, member_scale_resolution_down_by_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::RTCRtpScaleResolutionDownToEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("scaleResolutionDownTo");
if (!bindings::GetDictionaryMemberFromV8Object<RTCResolutionRestriction, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), has_scale_resolution_down_to_, member_scale_resolution_down_to_, class_like_name, exception_state)) {
  return;
}
}
}

const base::span<const v8::Eternal<v8::Name>> RTCRtpEncodingParameters::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
