// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_RTP_CONTRIBUTING_SOURCE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_RTP_CONTRIBUTING_SOURCE_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT RTCRtpContributingSource : public bindings::DictionaryBase {
  
  public:
static RTCRtpContributingSource* Create() {
  return MakeGarbageCollected<RTCRtpContributingSource>();
}
static RTCRtpContributingSource* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCRtpContributingSource>(isolate);
}
static RTCRtpContributingSource* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCRtpContributingSource();
explicit  RTCRtpContributingSource(v8::Isolate* isolate);

bool hasAudioLevel() const {
  return has_audio_level_;
}
double audioLevel() const {
  DCHECK(hasAudioLevel());
return member_audio_level_;
}
double getAudioLevelOr(double fallback_value) const {
  if (!hasAudioLevel()) {
  return fallback_value;
}
return member_audio_level_;
}
void setAudioLevel(double value) {
  member_audio_level_ = value;
has_audio_level_ = true;
}

bool hasCaptureTimestamp() const {
  return has_capture_timestamp_;
}
double captureTimestamp() const {
  DCHECK(hasCaptureTimestamp());
return member_capture_timestamp_;
}
double getCaptureTimestampOr(double fallback_value) const {
  if (!hasCaptureTimestamp()) {
  return fallback_value;
}
return member_capture_timestamp_;
}
void setCaptureTimestamp(double value) {
  member_capture_timestamp_ = value;
has_capture_timestamp_ = true;
}

bool hasRtpTimestamp() const {
  return true;
}
uint32_t rtpTimestamp() const {
  return member_rtp_timestamp_;
}
void setRtpTimestamp(uint32_t value) {
  member_rtp_timestamp_ = value;
}

bool hasSenderCaptureTimeOffset() const {
  return has_sender_capture_time_offset_;
}
double senderCaptureTimeOffset() const {
  DCHECK(hasSenderCaptureTimeOffset());
return member_sender_capture_time_offset_;
}
double getSenderCaptureTimeOffsetOr(double fallback_value) const {
  if (!hasSenderCaptureTimeOffset()) {
  return fallback_value;
}
return member_sender_capture_time_offset_;
}
void setSenderCaptureTimeOffset(double value) {
  member_sender_capture_time_offset_ = value;
has_sender_capture_time_offset_ = true;
}

bool hasSource() const {
  return true;
}
uint32_t source() const {
  return member_source_;
}
void setSource(uint32_t value) {
  member_source_ = value;
}

bool hasTimestamp() const {
  return true;
}
double timestamp() const {
  return member_timestamp_;
}
void setTimestamp(double value) {
  member_timestamp_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 6;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_audio_level_ = false;
bool has_capture_timestamp_ = false;
bool has_sender_capture_time_offset_ = false;

double member_audio_level_;
double member_capture_timestamp_;
uint32_t member_rtp_timestamp_;
double member_sender_capture_time_offset_;
uint32_t member_source_;
double member_timestamp_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_RTP_CONTRIBUTING_SOURCE_H_
