// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_rtp_codec.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"channels",
"clockRate",
"mimeType",
"sdpFmtpLine",
};


}  // namespace 

RTCRtpCodec* RTCRtpCodec::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  RTCRtpCodec* dictionary = MakeGarbageCollected<RTCRtpCodec>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "RTCRtpCodec";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 RTCRtpCodec::RTCRtpCodec() {
  
}

 RTCRtpCodec::RTCRtpCodec(v8::Isolate* isolate) {
  
}















void RTCRtpCodec::setMimeType(const String& value) {
  member_mime_type_ = value;
}

void RTCRtpCodec::setMimeType(String&& value) {
  member_mime_type_ = std::move(value);
}




String RTCRtpCodec::getSdpFmtpLineOr(const String& fallback_value) const {
  if (!hasSdpFmtpLine()) {
  return fallback_value;
}
return member_sdp_fmtp_line_;
}

String RTCRtpCodec::getSdpFmtpLineOr(String&& fallback_value) const {
  if (!hasSdpFmtpLine()) {
  return std::move(fallback_value);
}
return member_sdp_fmtp_line_;
}

void RTCRtpCodec::setSdpFmtpLine(const String& value) {
  member_sdp_fmtp_line_ = value;
has_sdp_fmtp_line_ = true;
}

void RTCRtpCodec::setSdpFmtpLine(String&& value) {
  member_sdp_fmtp_line_ = std::move(value);
has_sdp_fmtp_line_ = true;
}




void RTCRtpCodec::Trace(Visitor* visitor) const {
  bindings::DictionaryBase::Trace(visitor);
}

void RTCRtpCodec::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void RTCRtpCodec::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasChannels()) {
  values[0] = ToV8Traits<IDLUnsignedShort>::ToV8(script_state, member_channels_);
DCHECK(!values[0].IsEmpty());
}
if (hasClockRate()) {
  values[1] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_clock_rate_);
DCHECK(!values[1].IsEmpty());
}
if (hasMimeType()) {
  values[2] = ToV8Traits<IDLString>::ToV8(script_state, member_mime_type_);
DCHECK(!values[2].IsEmpty());
}
if (hasSdpFmtpLine()) {
  values[3] = ToV8Traits<IDLString>::ToV8(script_state, member_sdp_fmtp_line_);
DCHECK(!values[3].IsEmpty());
}
}

const void* RTCRtpCodec::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> RTCRtpCodec::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void RTCRtpCodec::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "RTCRtpCodec";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("channels");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedShort, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_channels_, member_channels_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("clockRate");
constexpr bool is_required = true;
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_clock_rate_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("mimeType");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_mime_type_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("sdpFmtpLine");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_sdp_fmtp_line_, member_sdp_fmtp_line_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> RTCRtpCodec::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
