// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_remote_outbound_rtp_stream_stats.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"localId",
"remoteTimestamp",
"reportsSent",
"roundTripTime",
"roundTripTimeMeasurements",
"totalRoundTripTime",
};


}  // namespace 

RTCRemoteOutboundRtpStreamStats* RTCRemoteOutboundRtpStreamStats::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  RTCRemoteOutboundRtpStreamStats* dictionary = MakeGarbageCollected<RTCRemoteOutboundRtpStreamStats>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "RTCRemoteOutboundRtpStreamStats";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 RTCRemoteOutboundRtpStreamStats::RTCRemoteOutboundRtpStreamStats() {
  
}

 RTCRemoteOutboundRtpStreamStats::RTCRemoteOutboundRtpStreamStats(v8::Isolate* isolate) : RTCSentRtpStreamStats(isolate) {
  
}



String RTCRemoteOutboundRtpStreamStats::getLocalIdOr(const String& fallback_value) const {
  if (!hasLocalId()) {
  return fallback_value;
}
return member_local_id_;
}

String RTCRemoteOutboundRtpStreamStats::getLocalIdOr(String&& fallback_value) const {
  if (!hasLocalId()) {
  return std::move(fallback_value);
}
return member_local_id_;
}

void RTCRemoteOutboundRtpStreamStats::setLocalId(const String& value) {
  member_local_id_ = value;
has_local_id_ = true;
}

void RTCRemoteOutboundRtpStreamStats::setLocalId(String&& value) {
  member_local_id_ = std::move(value);
has_local_id_ = true;
}







































void RTCRemoteOutboundRtpStreamStats::Trace(Visitor* visitor) const {
  RTCSentRtpStreamStats::Trace(visitor);
}

void RTCRemoteOutboundRtpStreamStats::FillTemplateProperties(Vector<std::string_view>& properties) const {
  RTCSentRtpStreamStats::FillTemplateProperties(properties);
DCHECK_EQ(properties.size(), kBasePropertyCount);

static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void RTCRemoteOutboundRtpStreamStats::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  RTCSentRtpStreamStats::FillValuesImpl(script_state, values.first(kBasePropertyCount));
values = values.subspan(kBasePropertyCount);

CHECK_EQ(kOwnPropertyCount, values.size());
if (hasLocalId()) {
  values[0] = ToV8Traits<IDLString>::ToV8(script_state, member_local_id_);
DCHECK(!values[0].IsEmpty());
}
if (hasRemoteTimestamp()) {
  values[1] = ToV8Traits<IDLDouble>::ToV8(script_state, member_remote_timestamp_);
DCHECK(!values[1].IsEmpty());
}
if (hasReportsSent()) {
  values[2] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_reports_sent_);
DCHECK(!values[2].IsEmpty());
}
if (hasRoundTripTime()) {
  values[3] = ToV8Traits<IDLDouble>::ToV8(script_state, member_round_trip_time_);
DCHECK(!values[3].IsEmpty());
}
if (hasRoundTripTimeMeasurements()) {
  values[4] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_round_trip_time_measurements_);
DCHECK(!values[4].IsEmpty());
}
if (hasTotalRoundTripTime()) {
  values[5] = ToV8Traits<IDLDouble>::ToV8(script_state, member_total_round_trip_time_);
DCHECK(!values[5].IsEmpty());
}
}

const void* RTCRemoteOutboundRtpStreamStats::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> RTCRemoteOutboundRtpStreamStats::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void RTCRemoteOutboundRtpStreamStats::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
RTCSentRtpStreamStats::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "RTCRemoteOutboundRtpStreamStats";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("localId");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_local_id_, member_local_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("remoteTimestamp");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_remote_timestamp_, member_remote_timestamp_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("reportsSent");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_reports_sent_, member_reports_sent_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("roundTripTime");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_round_trip_time_, member_round_trip_time_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("roundTripTimeMeasurements");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_round_trip_time_measurements_, member_round_trip_time_measurements_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("totalRoundTripTime");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_total_round_trip_time_, member_total_round_trip_time_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> RTCRemoteOutboundRtpStreamStats::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
