// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_received_rtp_stream_stats.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"jitter",
"packetsLost",
"packetsReceived",
"packetsReceivedWithCe",
"packetsReceivedWithEct1",
};


}  // namespace 

RTCReceivedRtpStreamStats* RTCReceivedRtpStreamStats::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  RTCReceivedRtpStreamStats* dictionary = MakeGarbageCollected<RTCReceivedRtpStreamStats>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "RTCReceivedRtpStreamStats";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 RTCReceivedRtpStreamStats::RTCReceivedRtpStreamStats() {
  
}

 RTCReceivedRtpStreamStats::RTCReceivedRtpStreamStats(v8::Isolate* isolate) : RTCRtpStreamStats(isolate) {
  
}






































void RTCReceivedRtpStreamStats::Trace(Visitor* visitor) const {
  RTCRtpStreamStats::Trace(visitor);
}

void RTCReceivedRtpStreamStats::FillTemplateProperties(Vector<std::string_view>& properties) const {
  RTCRtpStreamStats::FillTemplateProperties(properties);
DCHECK_EQ(properties.size(), kBasePropertyCount);

static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void RTCReceivedRtpStreamStats::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  RTCRtpStreamStats::FillValuesImpl(script_state, values.first(kBasePropertyCount));
values = values.subspan(kBasePropertyCount);

CHECK_EQ(kOwnPropertyCount, values.size());
if (hasJitter()) {
  values[0] = ToV8Traits<IDLDouble>::ToV8(script_state, member_jitter_);
DCHECK(!values[0].IsEmpty());
}
if (hasPacketsLost()) {
  values[1] = ToV8Traits<IDLLongLong>::ToV8(script_state, member_packets_lost_);
DCHECK(!values[1].IsEmpty());
}
if (hasPacketsReceived()) {
  values[2] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_packets_received_);
DCHECK(!values[2].IsEmpty());
}
if (hasPacketsReceivedWithCe()) {
  values[3] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_packets_received_with_ce_);
DCHECK(!values[3].IsEmpty());
}
if (hasPacketsReceivedWithEct1()) {
  values[4] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_packets_received_with_ect_1_);
DCHECK(!values[4].IsEmpty());
}
}

const void* RTCReceivedRtpStreamStats::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> RTCReceivedRtpStreamStats::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void RTCReceivedRtpStreamStats::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
RTCRtpStreamStats::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "RTCReceivedRtpStreamStats";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("jitter");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_jitter_, member_jitter_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("packetsLost");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_packets_lost_, member_packets_lost_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("packetsReceived");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_packets_received_, member_packets_received_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("packetsReceivedWithCe");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_packets_received_with_ce_, member_packets_received_with_ce_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("packetsReceivedWithEct1");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_packets_received_with_ect_1_, member_packets_received_with_ect_1_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> RTCReceivedRtpStreamStats::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
