// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_ICE_CANDIDATE_PAIR_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_ICE_CANDIDATE_PAIR_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class RTCIceCandidate;

class MODULES_EXPORT RTCIceCandidatePair : public bindings::DictionaryBase {
  
  public:
static RTCIceCandidatePair* Create() {
  return MakeGarbageCollected<RTCIceCandidatePair>();
}
static RTCIceCandidatePair* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCIceCandidatePair>(isolate);
}
static RTCIceCandidatePair* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCIceCandidatePair();
explicit  RTCIceCandidatePair(v8::Isolate* isolate);

bool hasLocal() const {
  return has_local_;
}
RTCIceCandidate* local() const {
  DCHECK(hasLocal());
return member_local_.Get();
}
RTCIceCandidate* getLocalOr(RTCIceCandidate* fallback_value) const {
  if (!hasLocal()) {
  return fallback_value;
}
return member_local_.Get();
}
void setLocal(RTCIceCandidate* value) {
  member_local_ = value;
has_local_ = true;
DCHECK(member_local_);
}

bool hasRemote() const {
  return has_remote_;
}
RTCIceCandidate* remote() const {
  DCHECK(hasRemote());
return member_remote_.Get();
}
RTCIceCandidate* getRemoteOr(RTCIceCandidate* fallback_value) const {
  if (!hasRemote()) {
  return fallback_value;
}
return member_remote_.Get();
}
void setRemote(RTCIceCandidate* value) {
  member_remote_ = value;
has_remote_ = true;
DCHECK(member_remote_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_local_ = false;
bool has_remote_ = false;

Member<RTCIceCandidate> member_local_;
Member<RTCIceCandidate> member_remote_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_ICE_CANDIDATE_PAIR_H_
