// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_encoded_video_frame_metadata.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"dependencies",
"frameId",
"height",
"spatialIndex",
"temporalIndex",
"timestamp",
"width",
};


}  // namespace 

RTCEncodedVideoFrameMetadata* RTCEncodedVideoFrameMetadata::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  RTCEncodedVideoFrameMetadata* dictionary = MakeGarbageCollected<RTCEncodedVideoFrameMetadata>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "RTCEncodedVideoFrameMetadata";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 RTCEncodedVideoFrameMetadata::RTCEncodedVideoFrameMetadata() {
  
}

 RTCEncodedVideoFrameMetadata::RTCEncodedVideoFrameMetadata(v8::Isolate* isolate) : RTCEncodedFrameMetadata(isolate) {
  
}



Vector<int64_t> RTCEncodedVideoFrameMetadata::getDependenciesOr(const Vector<int64_t>& fallback_value) const {
  if (!hasDependencies()) {
  return fallback_value;
}
return member_dependencies_;
}

Vector<int64_t> RTCEncodedVideoFrameMetadata::getDependenciesOr(Vector<int64_t>&& fallback_value) const {
  if (!hasDependencies()) {
  return std::move(fallback_value);
}
return member_dependencies_;
}

void RTCEncodedVideoFrameMetadata::setDependencies(const Vector<int64_t>& value) {
  member_dependencies_ = value;
has_dependencies_ = true;
}

void RTCEncodedVideoFrameMetadata::setDependencies(Vector<int64_t>&& value) {
  member_dependencies_ = std::move(value);
has_dependencies_ = true;
}














































void RTCEncodedVideoFrameMetadata::Trace(Visitor* visitor) const {
  RTCEncodedFrameMetadata::Trace(visitor);
}

void RTCEncodedVideoFrameMetadata::FillTemplateProperties(Vector<std::string_view>& properties) const {
  RTCEncodedFrameMetadata::FillTemplateProperties(properties);
DCHECK_EQ(properties.size(), kBasePropertyCount);

static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void RTCEncodedVideoFrameMetadata::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  RTCEncodedFrameMetadata::FillValuesImpl(script_state, values.first(kBasePropertyCount));
values = values.subspan(kBasePropertyCount);

CHECK_EQ(kOwnPropertyCount, values.size());
if (hasDependencies()) {
  values[0] = ToV8Traits<IDLSequence<IDLLongLong>>::ToV8(script_state, member_dependencies_);
DCHECK(!values[0].IsEmpty());
}
if (hasFrameId()) {
  values[1] = ToV8Traits<IDLLongLong>::ToV8(script_state, member_frame_id_);
DCHECK(!values[1].IsEmpty());
}
if (hasHeight()) {
  values[2] = ToV8Traits<IDLUnsignedShort>::ToV8(script_state, member_height_);
DCHECK(!values[2].IsEmpty());
}
if (hasSpatialIndex()) {
  values[3] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_spatial_index_);
DCHECK(!values[3].IsEmpty());
}
if (hasTemporalIndex()) {
  values[4] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_temporal_index_);
DCHECK(!values[4].IsEmpty());
}
if (RuntimeEnabledFeatures::RTCEncodedVideoFrameAdditionalMetadataEnabled()) {
  if (hasTimestamp()) {
  values[5] = ToV8Traits<IDLLongLong>::ToV8(script_state, member_timestamp_);
DCHECK(!values[5].IsEmpty());
}
}
if (hasWidth()) {
  values[6] = ToV8Traits<IDLUnsignedShort>::ToV8(script_state, member_width_);
DCHECK(!values[6].IsEmpty());
}
}

const void* RTCEncodedVideoFrameMetadata::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> RTCEncodedVideoFrameMetadata::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void RTCEncodedVideoFrameMetadata::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
RTCEncodedFrameMetadata::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "RTCEncodedVideoFrameMetadata";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("dependencies");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLLongLong>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_dependencies_, member_dependencies_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("frameId");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_frame_id_, member_frame_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("height");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedShort, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_height_, member_height_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("spatialIndex");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_spatial_index_, member_spatial_index_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("temporalIndex");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_temporal_index_, member_temporal_index_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::RTCEncodedVideoFrameAdditionalMetadataEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("timestamp");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_timestamp_, member_timestamp_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("width");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedShort, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_width_, member_width_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> RTCEncodedVideoFrameMetadata::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
