// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_encoded_frame_metadata.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"captureTime",
"contributingSources",
"mimeType",
"payloadType",
"receiveTime",
"rtpTimestamp",
"senderCaptureTimeOffset",
"synchronizationSource",
};


}  // namespace 

RTCEncodedFrameMetadata* RTCEncodedFrameMetadata::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  RTCEncodedFrameMetadata* dictionary = MakeGarbageCollected<RTCEncodedFrameMetadata>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "RTCEncodedFrameMetadata";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 RTCEncodedFrameMetadata::RTCEncodedFrameMetadata() {
  
}

 RTCEncodedFrameMetadata::RTCEncodedFrameMetadata(v8::Isolate* isolate) {
  
}










Vector<uint32_t> RTCEncodedFrameMetadata::getContributingSourcesOr(const Vector<uint32_t>& fallback_value) const {
  if (!hasContributingSources()) {
  return fallback_value;
}
return member_contributing_sources_;
}

Vector<uint32_t> RTCEncodedFrameMetadata::getContributingSourcesOr(Vector<uint32_t>&& fallback_value) const {
  if (!hasContributingSources()) {
  return std::move(fallback_value);
}
return member_contributing_sources_;
}

void RTCEncodedFrameMetadata::setContributingSources(const Vector<uint32_t>& value) {
  member_contributing_sources_ = value;
has_contributing_sources_ = true;
}

void RTCEncodedFrameMetadata::setContributingSources(Vector<uint32_t>&& value) {
  member_contributing_sources_ = std::move(value);
has_contributing_sources_ = true;
}




String RTCEncodedFrameMetadata::getMimeTypeOr(const String& fallback_value) const {
  if (!hasMimeType()) {
  return fallback_value;
}
return member_mime_type_;
}

String RTCEncodedFrameMetadata::getMimeTypeOr(String&& fallback_value) const {
  if (!hasMimeType()) {
  return std::move(fallback_value);
}
return member_mime_type_;
}

void RTCEncodedFrameMetadata::setMimeType(const String& value) {
  member_mime_type_ = value;
has_mime_type_ = true;
}

void RTCEncodedFrameMetadata::setMimeType(String&& value) {
  member_mime_type_ = std::move(value);
has_mime_type_ = true;
}







































void RTCEncodedFrameMetadata::Trace(Visitor* visitor) const {
  bindings::DictionaryBase::Trace(visitor);
}

void RTCEncodedFrameMetadata::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void RTCEncodedFrameMetadata::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (RuntimeEnabledFeatures::RTCEncodedFrameTimestampsEnabled()) {
  if (hasCaptureTime()) {
  values[0] = ToV8Traits<IDLDouble>::ToV8(script_state, member_capture_time_);
DCHECK(!values[0].IsEmpty());
}
}
if (hasContributingSources()) {
  values[1] = ToV8Traits<IDLSequence<IDLUnsignedLong>>::ToV8(script_state, member_contributing_sources_);
DCHECK(!values[1].IsEmpty());
}
if (hasMimeType()) {
  values[2] = ToV8Traits<IDLString>::ToV8(script_state, member_mime_type_);
DCHECK(!values[2].IsEmpty());
}
if (hasPayloadType()) {
  values[3] = ToV8Traits<IDLOctet>::ToV8(script_state, member_payload_type_);
DCHECK(!values[3].IsEmpty());
}
if (RuntimeEnabledFeatures::RTCEncodedFrameTimestampsEnabled()) {
  if (hasReceiveTime()) {
  values[4] = ToV8Traits<IDLDouble>::ToV8(script_state, member_receive_time_);
DCHECK(!values[4].IsEmpty());
}
}
if (hasRtpTimestamp()) {
  values[5] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_rtp_timestamp_);
DCHECK(!values[5].IsEmpty());
}
if (RuntimeEnabledFeatures::RTCEncodedFrameTimestampsEnabled()) {
  if (hasSenderCaptureTimeOffset()) {
  values[6] = ToV8Traits<IDLDouble>::ToV8(script_state, member_sender_capture_time_offset_);
DCHECK(!values[6].IsEmpty());
}
}
if (hasSynchronizationSource()) {
  values[7] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_synchronization_source_);
DCHECK(!values[7].IsEmpty());
}
}

const void* RTCEncodedFrameMetadata::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> RTCEncodedFrameMetadata::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void RTCEncodedFrameMetadata::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "RTCEncodedFrameMetadata";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (RuntimeEnabledFeatures::RTCEncodedFrameTimestampsEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("captureTime");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_capture_time_, member_capture_time_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("contributingSources");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLUnsignedLong>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_contributing_sources_, member_contributing_sources_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("mimeType");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_mime_type_, member_mime_type_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("payloadType");
if (!bindings::GetDictionaryMemberFromV8Object<IDLOctet, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_payload_type_, member_payload_type_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::RTCEncodedFrameTimestampsEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("receiveTime");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_receive_time_, member_receive_time_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("rtpTimestamp");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_rtp_timestamp_, member_rtp_timestamp_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::RTCEncodedFrameTimestampsEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("senderCaptureTimeOffset");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_sender_capture_time_offset_, member_sender_capture_time_offset_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("synchronizationSource");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_synchronization_source_, member_synchronization_source_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> RTCEncodedFrameMetadata::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
