// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_DATA_CHANNEL_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_DATA_CHANNEL_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_priority_type.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT RTCDataChannelInit : public bindings::InputDictionaryBase {
  
  public:
static RTCDataChannelInit* Create() {
  return MakeGarbageCollected<RTCDataChannelInit>();
}
static RTCDataChannelInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCDataChannelInit>(isolate);
}
static RTCDataChannelInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCDataChannelInit();
explicit  RTCDataChannelInit(v8::Isolate* isolate);

bool hasId() const {
  return has_id_;
}
uint16_t id() const {
  DCHECK(hasId());
return member_id_;
}
uint16_t getIdOr(uint16_t fallback_value) const {
  if (!hasId()) {
  return fallback_value;
}
return member_id_;
}
void setId(uint16_t value) {
  member_id_ = value;
has_id_ = true;
}

bool hasMaxPacketLifeTime() const {
  return has_max_packet_life_time_;
}
uint16_t maxPacketLifeTime() const {
  DCHECK(hasMaxPacketLifeTime());
return member_max_packet_life_time_;
}
uint16_t getMaxPacketLifeTimeOr(uint16_t fallback_value) const {
  if (!hasMaxPacketLifeTime()) {
  return fallback_value;
}
return member_max_packet_life_time_;
}
void setMaxPacketLifeTime(uint16_t value) {
  member_max_packet_life_time_ = value;
has_max_packet_life_time_ = true;
}

bool hasMaxRetransmits() const {
  return has_max_retransmits_;
}
uint16_t maxRetransmits() const {
  DCHECK(hasMaxRetransmits());
return member_max_retransmits_;
}
uint16_t getMaxRetransmitsOr(uint16_t fallback_value) const {
  if (!hasMaxRetransmits()) {
  return fallback_value;
}
return member_max_retransmits_;
}
void setMaxRetransmits(uint16_t value) {
  member_max_retransmits_ = value;
has_max_retransmits_ = true;
}

bool hasNegotiated() const {
  return true;
}
bool negotiated() const {
  return member_negotiated_;
}
void setNegotiated(bool value) {
  member_negotiated_ = value;
}

bool hasOrdered() const {
  return true;
}
bool ordered() const {
  return member_ordered_;
}
void setOrdered(bool value) {
  member_ordered_ = value;
}

bool hasPriority() const {
  return true;
}
V8RTCPriorityType priority() const {
  return member_priority_;
}
void setPriority(V8RTCPriorityType value) {
  member_priority_ = value;
}
void setPriority(V8RTCPriorityType::Enum value) {
  member_priority_ = V8RTCPriorityType(value);
}

bool hasProtocol() const {
  return true;
}
const String& protocol() const {
  return member_protocol_;
}
void setProtocol(const String& value);
void setProtocol(String&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 7;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_id_ = false;
bool has_max_packet_life_time_ = false;
bool has_max_retransmits_ = false;

uint16_t member_id_;
uint16_t member_max_packet_life_time_;
uint16_t member_max_retransmits_;
bool member_negotiated_{false};
bool member_ordered_{true};
V8RTCPriorityType member_priority_{V8RTCPriorityType::Enum::kLow};
String member_protocol_{""};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_DATA_CHANNEL_INIT_H_
