// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_CONFIGURATION_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_CONFIGURATION_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_bundle_policy.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_ice_transport_policy.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_rtcp_mux_policy.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class RTCCertificate;
class RTCIceServer;

class MODULES_EXPORT RTCConfiguration : public bindings::DictionaryBase {
  
  public:
static RTCConfiguration* Create() {
  return MakeGarbageCollected<RTCConfiguration>();
}
static RTCConfiguration* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCConfiguration>(isolate);
}
static RTCConfiguration* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCConfiguration();
explicit  RTCConfiguration(v8::Isolate* isolate);

bool hasBundlePolicy() const {
  return true;
}
V8RTCBundlePolicy bundlePolicy() const {
  return member_bundle_policy_;
}
void setBundlePolicy(V8RTCBundlePolicy value) {
  member_bundle_policy_ = value;
}
void setBundlePolicy(V8RTCBundlePolicy::Enum value) {
  member_bundle_policy_ = V8RTCBundlePolicy(value);
}

bool hasCertificates() const {
  return has_certificates_;
}
const HeapVector<Member<RTCCertificate>>& certificates() const {
  DCHECK(hasCertificates());
return member_certificates_;
}
HeapVector<Member<RTCCertificate>> getCertificatesOr(const HeapVector<Member<RTCCertificate>>& fallback_value) const;
HeapVector<Member<RTCCertificate>> getCertificatesOr(HeapVector<Member<RTCCertificate>>&& fallback_value) const;
void setCertificates(const HeapVector<Member<RTCCertificate>>& value);
void setCertificates(HeapVector<Member<RTCCertificate>>&& value);

bool hasEncodedInsertableStreams() const {
  return true;
}
bool encodedInsertableStreams() const {
  return member_encoded_insertable_streams_;
}
void setEncodedInsertableStreams(bool value) {
  member_encoded_insertable_streams_ = value;
}

bool hasIceCandidatePoolSize() const {
  return true;
}
uint8_t iceCandidatePoolSize() const {
  return member_ice_candidate_pool_size_;
}
void setIceCandidatePoolSize(uint8_t value) {
  member_ice_candidate_pool_size_ = value;
}

bool hasIceServers() const {
  return has_ice_servers_;
}
const HeapVector<Member<RTCIceServer>>& iceServers() const {
  DCHECK(hasIceServers());
return member_ice_servers_;
}
HeapVector<Member<RTCIceServer>> getIceServersOr(const HeapVector<Member<RTCIceServer>>& fallback_value) const;
HeapVector<Member<RTCIceServer>> getIceServersOr(HeapVector<Member<RTCIceServer>>&& fallback_value) const;
void setIceServers(const HeapVector<Member<RTCIceServer>>& value);
void setIceServers(HeapVector<Member<RTCIceServer>>&& value);

bool hasIceTransportPolicy() const {
  return has_ice_transport_policy_;
}
V8RTCIceTransportPolicy iceTransportPolicy() const {
  DCHECK(hasIceTransportPolicy());
return member_ice_transport_policy_;
}
V8RTCIceTransportPolicy getIceTransportPolicyOr(V8RTCIceTransportPolicy fallback_value) const {
  if (!hasIceTransportPolicy()) {
  return fallback_value;
}
return member_ice_transport_policy_;
}
void setIceTransportPolicy(V8RTCIceTransportPolicy value) {
  member_ice_transport_policy_ = value;
has_ice_transport_policy_ = true;
}
void setIceTransportPolicy(V8RTCIceTransportPolicy::Enum value) {
  member_ice_transport_policy_ = V8RTCIceTransportPolicy(value);
has_ice_transport_policy_ = true;
}

bool hasIceTransports() const {
  return has_ice_transports_;
}
V8RTCIceTransportPolicy iceTransports() const {
  DCHECK(hasIceTransports());
return member_ice_transports_;
}
V8RTCIceTransportPolicy getIceTransportsOr(V8RTCIceTransportPolicy fallback_value) const {
  if (!hasIceTransports()) {
  return fallback_value;
}
return member_ice_transports_;
}
void setIceTransports(V8RTCIceTransportPolicy value) {
  member_ice_transports_ = value;
has_ice_transports_ = true;
}
void setIceTransports(V8RTCIceTransportPolicy::Enum value) {
  member_ice_transports_ = V8RTCIceTransportPolicy(value);
has_ice_transports_ = true;
}

bool hasRtcAudioJitterBufferFastAccelerate() const {
  return has_rtc_audio_jitter_buffer_fast_accelerate_;
}
bool rtcAudioJitterBufferFastAccelerate() const {
  DCHECK(hasRtcAudioJitterBufferFastAccelerate());
return member_rtc_audio_jitter_buffer_fast_accelerate_;
}
bool getRtcAudioJitterBufferFastAccelerateOr(bool fallback_value) const {
  if (!hasRtcAudioJitterBufferFastAccelerate()) {
  return fallback_value;
}
return member_rtc_audio_jitter_buffer_fast_accelerate_;
}
void setRtcAudioJitterBufferFastAccelerate(bool value) {
  member_rtc_audio_jitter_buffer_fast_accelerate_ = value;
has_rtc_audio_jitter_buffer_fast_accelerate_ = true;
}

bool hasRtcAudioJitterBufferMaxPackets() const {
  return has_rtc_audio_jitter_buffer_max_packets_;
}
int32_t rtcAudioJitterBufferMaxPackets() const {
  DCHECK(hasRtcAudioJitterBufferMaxPackets());
return member_rtc_audio_jitter_buffer_max_packets_;
}
int32_t getRtcAudioJitterBufferMaxPacketsOr(int32_t fallback_value) const {
  if (!hasRtcAudioJitterBufferMaxPackets()) {
  return fallback_value;
}
return member_rtc_audio_jitter_buffer_max_packets_;
}
void setRtcAudioJitterBufferMaxPackets(int32_t value) {
  member_rtc_audio_jitter_buffer_max_packets_ = value;
has_rtc_audio_jitter_buffer_max_packets_ = true;
}

bool hasRtcAudioJitterBufferMinDelayMs() const {
  return has_rtc_audio_jitter_buffer_min_delay_ms_;
}
int32_t rtcAudioJitterBufferMinDelayMs() const {
  DCHECK(hasRtcAudioJitterBufferMinDelayMs());
return member_rtc_audio_jitter_buffer_min_delay_ms_;
}
int32_t getRtcAudioJitterBufferMinDelayMsOr(int32_t fallback_value) const {
  if (!hasRtcAudioJitterBufferMinDelayMs()) {
  return fallback_value;
}
return member_rtc_audio_jitter_buffer_min_delay_ms_;
}
void setRtcAudioJitterBufferMinDelayMs(int32_t value) {
  member_rtc_audio_jitter_buffer_min_delay_ms_ = value;
has_rtc_audio_jitter_buffer_min_delay_ms_ = true;
}

bool hasRtcpMuxPolicy() const {
  return true;
}
V8RTCRtcpMuxPolicy rtcpMuxPolicy() const {
  return member_rtcp_mux_policy_;
}
void setRtcpMuxPolicy(V8RTCRtcpMuxPolicy value) {
  member_rtcp_mux_policy_ = value;
}
void setRtcpMuxPolicy(V8RTCRtcpMuxPolicy::Enum value) {
  member_rtcp_mux_policy_ = V8RTCRtcpMuxPolicy(value);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 11;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_certificates_ = false;
bool has_ice_servers_ = false;
bool has_ice_transport_policy_ = false;
bool has_ice_transports_ = false;
bool has_rtc_audio_jitter_buffer_fast_accelerate_ = false;
bool has_rtc_audio_jitter_buffer_max_packets_ = false;
bool has_rtc_audio_jitter_buffer_min_delay_ms_ = false;

V8RTCBundlePolicy member_bundle_policy_{V8RTCBundlePolicy::Enum::kBalanced};
HeapVector<Member<RTCCertificate>> member_certificates_;
bool member_encoded_insertable_streams_{false};
uint8_t member_ice_candidate_pool_size_{0};
HeapVector<Member<RTCIceServer>> member_ice_servers_;
V8RTCIceTransportPolicy member_ice_transport_policy_{static_cast<V8RTCIceTransportPolicy::Enum>(0)};
V8RTCIceTransportPolicy member_ice_transports_{static_cast<V8RTCIceTransportPolicy::Enum>(0)};
bool member_rtc_audio_jitter_buffer_fast_accelerate_;
int32_t member_rtc_audio_jitter_buffer_max_packets_;
int32_t member_rtc_audio_jitter_buffer_min_delay_ms_;
V8RTCRtcpMuxPolicy member_rtcp_mux_policy_{V8RTCRtcpMuxPolicy::Enum::kRequire};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_CONFIGURATION_H_
