// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_CODEC_SPECIFICS_VP_8_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_CODEC_SPECIFICS_VP_8_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT RTCCodecSpecificsVP8 : public bindings::DictionaryBase {
  
  public:
static RTCCodecSpecificsVP8* Create() {
  return MakeGarbageCollected<RTCCodecSpecificsVP8>();
}
static RTCCodecSpecificsVP8* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCCodecSpecificsVP8>(isolate);
}
static RTCCodecSpecificsVP8* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCCodecSpecificsVP8();
explicit  RTCCodecSpecificsVP8(v8::Isolate* isolate);

bool hasBeginningOfPartition() const {
  return has_beginning_of_partition_;
}
bool beginningOfPartition() const {
  DCHECK(hasBeginningOfPartition());
return member_beginning_of_partition_;
}
bool getBeginningOfPartitionOr(bool fallback_value) const {
  if (!hasBeginningOfPartition()) {
  return fallback_value;
}
return member_beginning_of_partition_;
}
void setBeginningOfPartition(bool value) {
  member_beginning_of_partition_ = value;
has_beginning_of_partition_ = true;
}

bool hasKeyIdx() const {
  return has_key_idx_;
}
int32_t keyIdx() const {
  DCHECK(hasKeyIdx());
return member_key_idx_;
}
int32_t getKeyIdxOr(int32_t fallback_value) const {
  if (!hasKeyIdx()) {
  return fallback_value;
}
return member_key_idx_;
}
void setKeyIdx(int32_t value) {
  member_key_idx_ = value;
has_key_idx_ = true;
}

bool hasLayerSync() const {
  return has_layer_sync_;
}
bool layerSync() const {
  DCHECK(hasLayerSync());
return member_layer_sync_;
}
bool getLayerSyncOr(bool fallback_value) const {
  if (!hasLayerSync()) {
  return fallback_value;
}
return member_layer_sync_;
}
void setLayerSync(bool value) {
  member_layer_sync_ = value;
has_layer_sync_ = true;
}

bool hasNonReference() const {
  return has_non_reference_;
}
bool nonReference() const {
  DCHECK(hasNonReference());
return member_non_reference_;
}
bool getNonReferenceOr(bool fallback_value) const {
  if (!hasNonReference()) {
  return fallback_value;
}
return member_non_reference_;
}
void setNonReference(bool value) {
  member_non_reference_ = value;
has_non_reference_ = true;
}

bool hasPartitionId() const {
  return has_partition_id_;
}
int32_t partitionId() const {
  DCHECK(hasPartitionId());
return member_partition_id_;
}
int32_t getPartitionIdOr(int32_t fallback_value) const {
  if (!hasPartitionId()) {
  return fallback_value;
}
return member_partition_id_;
}
void setPartitionId(int32_t value) {
  member_partition_id_ = value;
has_partition_id_ = true;
}

bool hasPictureId() const {
  return has_picture_id_;
}
int16_t pictureId() const {
  DCHECK(hasPictureId());
return member_picture_id_;
}
int16_t getPictureIdOr(int16_t fallback_value) const {
  if (!hasPictureId()) {
  return fallback_value;
}
return member_picture_id_;
}
void setPictureId(int16_t value) {
  member_picture_id_ = value;
has_picture_id_ = true;
}

bool hasTemporalIdx() const {
  return has_temporal_idx_;
}
uint8_t temporalIdx() const {
  DCHECK(hasTemporalIdx());
return member_temporal_idx_;
}
uint8_t getTemporalIdxOr(uint8_t fallback_value) const {
  if (!hasTemporalIdx()) {
  return fallback_value;
}
return member_temporal_idx_;
}
void setTemporalIdx(uint8_t value) {
  member_temporal_idx_ = value;
has_temporal_idx_ = true;
}

bool hasTl0PicIdx() const {
  return has_tl_0_pic_idx_;
}
int16_t tl0PicIdx() const {
  DCHECK(hasTl0PicIdx());
return member_tl_0_pic_idx_;
}
int16_t getTl0PicIdxOr(int16_t fallback_value) const {
  if (!hasTl0PicIdx()) {
  return fallback_value;
}
return member_tl_0_pic_idx_;
}
void setTl0PicIdx(int16_t value) {
  member_tl_0_pic_idx_ = value;
has_tl_0_pic_idx_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 8;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_beginning_of_partition_ = false;
bool has_key_idx_ = false;
bool has_layer_sync_ = false;
bool has_non_reference_ = false;
bool has_partition_id_ = false;
bool has_picture_id_ = false;
bool has_temporal_idx_ = false;
bool has_tl_0_pic_idx_ = false;

bool member_beginning_of_partition_;
int32_t member_key_idx_;
bool member_layer_sync_;
bool member_non_reference_;
int32_t member_partition_id_;
int16_t member_picture_id_;
uint8_t member_temporal_idx_;
int16_t member_tl_0_pic_idx_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_CODEC_SPECIFICS_VP_8_H_
