// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_CERTIFICATE_STATS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_CERTIFICATE_STATS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_stats.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT RTCCertificateStats : public RTCStats {
  
  public:
static RTCCertificateStats* Create() {
  return MakeGarbageCollected<RTCCertificateStats>();
}
static RTCCertificateStats* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCCertificateStats>(isolate);
}
static RTCCertificateStats* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCCertificateStats();
explicit  RTCCertificateStats(v8::Isolate* isolate);

bool hasBase64Certificate() const {
  return true;
}
const String& base64Certificate() const {
  return member_base_64_certificate_;
}
void setBase64Certificate(const String& value);
void setBase64Certificate(String&& value);

bool hasFingerprint() const {
  return true;
}
const String& fingerprint() const {
  return member_fingerprint_;
}
void setFingerprint(const String& value);
void setFingerprint(String&& value);

bool hasFingerprintAlgorithm() const {
  return true;
}
const String& fingerprintAlgorithm() const {
  return member_fingerprint_algorithm_;
}
void setFingerprintAlgorithm(const String& value);
void setFingerprintAlgorithm(String&& value);

bool hasIssuerCertificateId() const {
  return has_issuer_certificate_id_;
}
const String& issuerCertificateId() const {
  DCHECK(hasIssuerCertificateId());
return member_issuer_certificate_id_;
}
String getIssuerCertificateIdOr(const String& fallback_value) const;
String getIssuerCertificateIdOr(String&& fallback_value) const;
void setIssuerCertificateId(const String& value);
void setIssuerCertificateId(String&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = RTCStats::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_issuer_certificate_id_ = false;

String member_base_64_certificate_;
String member_fingerprint_;
String member_fingerprint_algorithm_;
String member_issuer_certificate_id_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_CERTIFICATE_STATS_H_
