// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_rsa_other_primes_info.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"d",
"r",
"t",
};


}  // namespace 

RsaOtherPrimesInfo* RsaOtherPrimesInfo::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  RsaOtherPrimesInfo* dictionary = MakeGarbageCollected<RsaOtherPrimesInfo>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "RsaOtherPrimesInfo";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 RsaOtherPrimesInfo::RsaOtherPrimesInfo() {
  
}

 RsaOtherPrimesInfo::RsaOtherPrimesInfo(v8::Isolate* isolate) {
  
}



String RsaOtherPrimesInfo::getDOr(const String& fallback_value) const {
  if (!hasD()) {
  return fallback_value;
}
return member_d_;
}

String RsaOtherPrimesInfo::getDOr(String&& fallback_value) const {
  if (!hasD()) {
  return std::move(fallback_value);
}
return member_d_;
}

void RsaOtherPrimesInfo::setD(const String& value) {
  member_d_ = value;
has_d_ = true;
}

void RsaOtherPrimesInfo::setD(String&& value) {
  member_d_ = std::move(value);
has_d_ = true;
}




String RsaOtherPrimesInfo::getROr(const String& fallback_value) const {
  if (!hasR()) {
  return fallback_value;
}
return member_r_;
}

String RsaOtherPrimesInfo::getROr(String&& fallback_value) const {
  if (!hasR()) {
  return std::move(fallback_value);
}
return member_r_;
}

void RsaOtherPrimesInfo::setR(const String& value) {
  member_r_ = value;
has_r_ = true;
}

void RsaOtherPrimesInfo::setR(String&& value) {
  member_r_ = std::move(value);
has_r_ = true;
}




String RsaOtherPrimesInfo::getTOr(const String& fallback_value) const {
  if (!hasT()) {
  return fallback_value;
}
return member_t_;
}

String RsaOtherPrimesInfo::getTOr(String&& fallback_value) const {
  if (!hasT()) {
  return std::move(fallback_value);
}
return member_t_;
}

void RsaOtherPrimesInfo::setT(const String& value) {
  member_t_ = value;
has_t_ = true;
}

void RsaOtherPrimesInfo::setT(String&& value) {
  member_t_ = std::move(value);
has_t_ = true;
}




void RsaOtherPrimesInfo::Trace(Visitor* visitor) const {
  bindings::InputDictionaryBase::Trace(visitor);
}

void RsaOtherPrimesInfo::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "RsaOtherPrimesInfo";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("d");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_d_, member_d_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("r");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_r_, member_r_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("t");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_t_, member_t_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> RsaOtherPrimesInfo::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
