// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ROUTER_RULE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ROUTER_RULE_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_router_source_enum.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class RouterCondition;
class RouterSource;
class V8UnionRouterSourceOrRouterSourceEnum;

class MODULES_EXPORT RouterRule : public bindings::InputDictionaryBase {
  
  public:
static RouterRule* Create() {
  return MakeGarbageCollected<RouterRule>();
}
static RouterRule* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RouterRule>(isolate);
}
static RouterRule* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RouterRule();
explicit  RouterRule(v8::Isolate* isolate);

bool hasCondition() const {
  return has_condition_;
}
RouterCondition* condition() const {
  DCHECK(hasCondition());
return member_condition_.Get();
}
RouterCondition* getConditionOr(RouterCondition* fallback_value) const {
  if (!hasCondition()) {
  return fallback_value;
}
return member_condition_.Get();
}
void setCondition(RouterCondition* value) {
  member_condition_ = value;
has_condition_ = true;
DCHECK(member_condition_);
}

bool hasSource() const {
  return has_source_;
}
V8UnionRouterSourceOrRouterSourceEnum* source() const {
  DCHECK(hasSource());
return member_source_.Get();
}
V8UnionRouterSourceOrRouterSourceEnum* getSourceOr(V8UnionRouterSourceOrRouterSourceEnum* fallback_value) const {
  if (!hasSource()) {
  return fallback_value;
}
return member_source_.Get();
}
void setSource(V8UnionRouterSourceOrRouterSourceEnum* value) {
  member_source_ = value;
has_source_ = true;
DCHECK(member_source_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_condition_ = false;
bool has_source_ = false;

Member<RouterCondition> member_condition_;
Member<V8UnionRouterSourceOrRouterSourceEnum> member_source_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ROUTER_RULE_H_
