// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ROUTER_CONDITION_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ROUTER_CONDITION_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_request_destination.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_request_mode.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_running_status_enum.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class RouterCondition;
class URLPattern;
class URLPatternInit;
class V8UnionURLPatternOrURLPatternInitOrUSVString;

class MODULES_EXPORT RouterCondition : public bindings::InputDictionaryBase {
  
  public:
static RouterCondition* Create() {
  return MakeGarbageCollected<RouterCondition>();
}
static RouterCondition* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RouterCondition>(isolate);
}
static RouterCondition* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RouterCondition();
explicit  RouterCondition(v8::Isolate* isolate);

bool hasNotCondition() const {
  return has_not_condition_;
}
RouterCondition* notCondition() const {
  DCHECK(hasNotCondition());
return member_not_condition_.Get();
}
RouterCondition* getNotConditionOr(RouterCondition* fallback_value) const {
  if (!hasNotCondition()) {
  return fallback_value;
}
return member_not_condition_.Get();
}
void setNotCondition(RouterCondition* value) {
  member_not_condition_ = value;
has_not_condition_ = true;
DCHECK(member_not_condition_);
}

bool hasOrConditions() const {
  return has_or_conditions_;
}
const HeapVector<Member<RouterCondition>>& orConditions() const {
  DCHECK(hasOrConditions());
return member_or_conditions_;
}
HeapVector<Member<RouterCondition>> getOrConditionsOr(const HeapVector<Member<RouterCondition>>& fallback_value) const;
HeapVector<Member<RouterCondition>> getOrConditionsOr(HeapVector<Member<RouterCondition>>&& fallback_value) const;
void setOrConditions(const HeapVector<Member<RouterCondition>>& value);
void setOrConditions(HeapVector<Member<RouterCondition>>&& value);

bool hasRequestDestination() const {
  return has_request_destination_;
}
V8RequestDestination requestDestination() const {
  DCHECK(hasRequestDestination());
return member_request_destination_;
}
V8RequestDestination getRequestDestinationOr(V8RequestDestination fallback_value) const {
  if (!hasRequestDestination()) {
  return fallback_value;
}
return member_request_destination_;
}
void setRequestDestination(V8RequestDestination value) {
  member_request_destination_ = value;
has_request_destination_ = true;
}
void setRequestDestination(V8RequestDestination::Enum value) {
  member_request_destination_ = V8RequestDestination(value);
has_request_destination_ = true;
}

bool hasRequestMethod() const {
  return has_request_method_;
}
const String& requestMethod() const {
  DCHECK(hasRequestMethod());
return member_request_method_;
}
String getRequestMethodOr(const String& fallback_value) const;
String getRequestMethodOr(String&& fallback_value) const;
void setRequestMethod(const String& value);
void setRequestMethod(String&& value);

bool hasRequestMode() const {
  return has_request_mode_;
}
V8RequestMode requestMode() const {
  DCHECK(hasRequestMode());
return member_request_mode_;
}
V8RequestMode getRequestModeOr(V8RequestMode fallback_value) const {
  if (!hasRequestMode()) {
  return fallback_value;
}
return member_request_mode_;
}
void setRequestMode(V8RequestMode value) {
  member_request_mode_ = value;
has_request_mode_ = true;
}
void setRequestMode(V8RequestMode::Enum value) {
  member_request_mode_ = V8RequestMode(value);
has_request_mode_ = true;
}

bool hasRunningStatus() const {
  return has_running_status_;
}
V8RunningStatusEnum runningStatus() const {
  DCHECK(hasRunningStatus());
return member_running_status_;
}
V8RunningStatusEnum getRunningStatusOr(V8RunningStatusEnum fallback_value) const {
  if (!hasRunningStatus()) {
  return fallback_value;
}
return member_running_status_;
}
void setRunningStatus(V8RunningStatusEnum value) {
  member_running_status_ = value;
has_running_status_ = true;
}
void setRunningStatus(V8RunningStatusEnum::Enum value) {
  member_running_status_ = V8RunningStatusEnum(value);
has_running_status_ = true;
}

bool hasUrlPattern() const {
  return has_url_pattern_;
}
V8UnionURLPatternOrURLPatternInitOrUSVString* urlPattern() const {
  DCHECK(hasUrlPattern());
return member_url_pattern_.Get();
}
V8UnionURLPatternOrURLPatternInitOrUSVString* getUrlPatternOr(V8UnionURLPatternOrURLPatternInitOrUSVString* fallback_value) const {
  if (!hasUrlPattern()) {
  return fallback_value;
}
return member_url_pattern_.Get();
}
void setUrlPattern(V8UnionURLPatternOrURLPatternInitOrUSVString* value) {
  member_url_pattern_ = value;
has_url_pattern_ = true;
DCHECK(member_url_pattern_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 7;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_not_condition_ = false;
bool has_or_conditions_ = false;
bool has_request_destination_ = false;
bool has_request_method_ = false;
bool has_request_mode_ = false;
bool has_running_status_ = false;
bool has_url_pattern_ = false;

Member<RouterCondition> member_not_condition_;
HeapVector<Member<RouterCondition>> member_or_conditions_;
V8RequestDestination member_request_destination_{static_cast<V8RequestDestination::Enum>(0)};
String member_request_method_;
V8RequestMode member_request_mode_{static_cast<V8RequestMode::Enum>(0)};
V8RunningStatusEnum member_running_status_{static_cast<V8RunningStatusEnum::Enum>(0)};
Member<V8UnionURLPatternOrURLPatternInitOrUSVString> member_url_pattern_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ROUTER_CONDITION_H_
