// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_rewriter_create_options.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_create_monitor_callback.h"
#include "third_party/blink/renderer/core/dom/abort_signal.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"monitor",
"sharedContext",
"signal",
};


}  // namespace 

RewriterCreateOptions* RewriterCreateOptions::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  RewriterCreateOptions* dictionary = MakeGarbageCollected<RewriterCreateOptions>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "RewriterCreateOptions";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 RewriterCreateOptions::RewriterCreateOptions() {
  
}

 RewriterCreateOptions::RewriterCreateOptions(v8::Isolate* isolate) : RewriterCreateCoreOptions(isolate) {
  
}










String RewriterCreateOptions::getSharedContextOr(const String& fallback_value) const {
  if (!hasSharedContext()) {
  return fallback_value;
}
return member_shared_context_;
}

String RewriterCreateOptions::getSharedContextOr(String&& fallback_value) const {
  if (!hasSharedContext()) {
  return std::move(fallback_value);
}
return member_shared_context_;
}

void RewriterCreateOptions::setSharedContext(const String& value) {
  member_shared_context_ = value;
has_shared_context_ = true;
}

void RewriterCreateOptions::setSharedContext(String&& value) {
  member_shared_context_ = std::move(value);
has_shared_context_ = true;
}











void RewriterCreateOptions::Trace(Visitor* visitor) const {
  visitor->Trace(member_monitor_);
visitor->Trace(member_signal_);
RewriterCreateCoreOptions::Trace(visitor);
}

void RewriterCreateOptions::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
RewriterCreateCoreOptions::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "RewriterCreateOptions";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("monitor");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<V8CreateMonitorCallback, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_monitor_, member_monitor_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("sharedContext");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_shared_context_, member_shared_context_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("signal");
if (!bindings::GetDictionaryMemberFromV8Object<AbortSignal, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_signal_, member_signal_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> RewriterCreateOptions::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
