// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_request_device_options.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_string_unsignedlong.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_bluetooth_le_scan_filter_init.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"acceptAllDevices",
"exclusionFilters",
"filters",
"optionalManufacturerData",
"optionalServices",
};


}  // namespace 

RequestDeviceOptions* RequestDeviceOptions::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  RequestDeviceOptions* dictionary = MakeGarbageCollected<RequestDeviceOptions>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "RequestDeviceOptions";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 RequestDeviceOptions::RequestDeviceOptions() {
  
}

 RequestDeviceOptions::RequestDeviceOptions(v8::Isolate* isolate) {
  
}








HeapVector<Member<BluetoothLEScanFilterInit>> RequestDeviceOptions::getExclusionFiltersOr(const HeapVector<Member<BluetoothLEScanFilterInit>>& fallback_value) const {
  if (!hasExclusionFilters()) {
  return fallback_value;
}
return member_exclusion_filters_;
}

HeapVector<Member<BluetoothLEScanFilterInit>> RequestDeviceOptions::getExclusionFiltersOr(HeapVector<Member<BluetoothLEScanFilterInit>>&& fallback_value) const {
  if (!hasExclusionFilters()) {
  return std::move(fallback_value);
}
return member_exclusion_filters_;
}

void RequestDeviceOptions::setExclusionFilters(const HeapVector<Member<BluetoothLEScanFilterInit>>& value) {
  member_exclusion_filters_ = value;
has_exclusion_filters_ = true;
}

void RequestDeviceOptions::setExclusionFilters(HeapVector<Member<BluetoothLEScanFilterInit>>&& value) {
  member_exclusion_filters_ = std::move(value);
has_exclusion_filters_ = true;
}




HeapVector<Member<BluetoothLEScanFilterInit>> RequestDeviceOptions::getFiltersOr(const HeapVector<Member<BluetoothLEScanFilterInit>>& fallback_value) const {
  if (!hasFilters()) {
  return fallback_value;
}
return member_filters_;
}

HeapVector<Member<BluetoothLEScanFilterInit>> RequestDeviceOptions::getFiltersOr(HeapVector<Member<BluetoothLEScanFilterInit>>&& fallback_value) const {
  if (!hasFilters()) {
  return std::move(fallback_value);
}
return member_filters_;
}

void RequestDeviceOptions::setFilters(const HeapVector<Member<BluetoothLEScanFilterInit>>& value) {
  member_filters_ = value;
has_filters_ = true;
}

void RequestDeviceOptions::setFilters(HeapVector<Member<BluetoothLEScanFilterInit>>&& value) {
  member_filters_ = std::move(value);
has_filters_ = true;
}




void RequestDeviceOptions::setOptionalManufacturerData(const Vector<uint16_t>& value) {
  member_optional_manufacturer_data_ = value;
}

void RequestDeviceOptions::setOptionalManufacturerData(Vector<uint16_t>&& value) {
  member_optional_manufacturer_data_ = std::move(value);
}




void RequestDeviceOptions::setOptionalServices(const HeapVector<Member<V8UnionStringOrUnsignedLong>>& value) {
  member_optional_services_ = value;
}

void RequestDeviceOptions::setOptionalServices(HeapVector<Member<V8UnionStringOrUnsignedLong>>&& value) {
  member_optional_services_ = std::move(value);
}




void RequestDeviceOptions::Trace(Visitor* visitor) const {
  visitor->Trace(member_exclusion_filters_);
visitor->Trace(member_filters_);
visitor->Trace(member_optional_services_);
bindings::InputDictionaryBase::Trace(visitor);
}

void RequestDeviceOptions::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "RequestDeviceOptions";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("acceptAllDevices");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_accept_all_devices_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("exclusionFilters");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<BluetoothLEScanFilterInit>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_exclusion_filters_, member_exclusion_filters_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("filters");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<BluetoothLEScanFilterInit>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_filters_, member_filters_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::WebBluetoothWatchAdvertisementsEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("optionalManufacturerData");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLUnsignedShort>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_optional_manufacturer_data_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("optionalServices");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<V8UnionStringOrUnsignedLong>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), fallback_presence_var, member_optional_services_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> RequestDeviceOptions::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
