// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RELATED_APPLICATION_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RELATED_APPLICATION_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT RelatedApplication : public bindings::DictionaryBase {
  
  public:
static RelatedApplication* Create() {
  return MakeGarbageCollected<RelatedApplication>();
}
static RelatedApplication* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RelatedApplication>(isolate);
}
static RelatedApplication* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RelatedApplication();
explicit  RelatedApplication(v8::Isolate* isolate);

bool hasId() const {
  return has_id_;
}
const String& id() const {
  DCHECK(hasId());
return member_id_;
}
String getIdOr(const String& fallback_value) const;
String getIdOr(String&& fallback_value) const;
void setId(const String& value);
void setId(String&& value);

bool hasPlatform() const {
  return true;
}
const String& platform() const {
  return member_platform_;
}
void setPlatform(const String& value);
void setPlatform(String&& value);

bool hasUrl() const {
  return has_url_;
}
const String& url() const {
  DCHECK(hasUrl());
return member_url_;
}
String getUrlOr(const String& fallback_value) const;
String getUrlOr(String&& fallback_value) const;
void setUrl(const String& value);
void setUrl(String&& value);

bool hasVersion() const {
  return has_version_;
}
const String& version() const {
  DCHECK(hasVersion());
return member_version_;
}
String getVersionOr(const String& fallback_value) const;
String getVersionOr(String&& fallback_value) const;
void setVersion(const String& value);
void setVersion(String&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_id_ = false;
bool has_url_ = false;
bool has_version_ = false;

String member_id_;
String member_platform_;
String member_url_;
String member_version_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RELATED_APPLICATION_H_
