// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_registration_response_js_on.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_authentication_extensions_client_outputs_js_on.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_authenticator_attestation_response_js_on.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"authenticatorAttachment",
"clientExtensionResults",
"id",
"rawId",
"response",
"type",
};


}  // namespace 

RegistrationResponseJSON* RegistrationResponseJSON::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  RegistrationResponseJSON* dictionary = MakeGarbageCollected<RegistrationResponseJSON>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "RegistrationResponseJSON";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 RegistrationResponseJSON::RegistrationResponseJSON() {
  
}

 RegistrationResponseJSON::RegistrationResponseJSON(v8::Isolate* isolate) {
  
}



String RegistrationResponseJSON::getAuthenticatorAttachmentOr(const String& fallback_value) const {
  if (!hasAuthenticatorAttachment()) {
  return fallback_value;
}
return member_authenticator_attachment_;
}

String RegistrationResponseJSON::getAuthenticatorAttachmentOr(String&& fallback_value) const {
  if (!hasAuthenticatorAttachment()) {
  return std::move(fallback_value);
}
return member_authenticator_attachment_;
}

void RegistrationResponseJSON::setAuthenticatorAttachment(const String& value) {
  member_authenticator_attachment_ = value;
has_authenticator_attachment_ = true;
}

void RegistrationResponseJSON::setAuthenticatorAttachment(String&& value) {
  member_authenticator_attachment_ = std::move(value);
has_authenticator_attachment_ = true;
}









void RegistrationResponseJSON::setId(const String& value) {
  member_id_ = value;
}

void RegistrationResponseJSON::setId(String&& value) {
  member_id_ = std::move(value);
}




void RegistrationResponseJSON::setRawId(const String& value) {
  member_raw_id_ = value;
}

void RegistrationResponseJSON::setRawId(String&& value) {
  member_raw_id_ = std::move(value);
}









void RegistrationResponseJSON::setType(const String& value) {
  member_type_ = value;
}

void RegistrationResponseJSON::setType(String&& value) {
  member_type_ = std::move(value);
}




void RegistrationResponseJSON::Trace(Visitor* visitor) const {
  visitor->Trace(member_client_extension_results_);
visitor->Trace(member_response_);
bindings::DictionaryBase::Trace(visitor);
}

void RegistrationResponseJSON::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void RegistrationResponseJSON::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAuthenticatorAttachment()) {
  values[0] = ToV8Traits<IDLString>::ToV8(script_state, member_authenticator_attachment_);
DCHECK(!values[0].IsEmpty());
}
if (hasClientExtensionResults()) {
  values[1] = ToV8Traits<AuthenticationExtensionsClientOutputsJSON>::ToV8(script_state, member_client_extension_results_.Get());
DCHECK(!values[1].IsEmpty());
}
if (hasId()) {
  values[2] = ToV8Traits<IDLString>::ToV8(script_state, member_id_);
DCHECK(!values[2].IsEmpty());
}
if (hasRawId()) {
  values[3] = ToV8Traits<IDLString>::ToV8(script_state, member_raw_id_);
DCHECK(!values[3].IsEmpty());
}
if (hasResponse()) {
  values[4] = ToV8Traits<AuthenticatorAttestationResponseJSON>::ToV8(script_state, member_response_.Get());
DCHECK(!values[4].IsEmpty());
}
if (hasType()) {
  values[5] = ToV8Traits<IDLString>::ToV8(script_state, member_type_);
DCHECK(!values[5].IsEmpty());
}
}

const void* RegistrationResponseJSON::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> RegistrationResponseJSON::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void RegistrationResponseJSON::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "RegistrationResponseJSON";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("authenticatorAttachment");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_authenticator_attachment_, member_authenticator_attachment_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("clientExtensionResults");
constexpr bool is_required = true;
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<AuthenticationExtensionsClientOutputsJSON, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_client_extension_results_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("id");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("rawId");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_raw_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("response");
if (!bindings::GetDictionaryMemberFromV8Object<AuthenticatorAttestationResponseJSON, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), fallback_presence_var, member_response_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("type");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), fallback_presence_var, member_type_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> RegistrationResponseJSON::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
