// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_REGISTRATION_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_REGISTRATION_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_worker_type.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_service_worker_update_via_cache.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT RegistrationOptions : public bindings::InputDictionaryBase {
  
  public:
static RegistrationOptions* Create() {
  return MakeGarbageCollected<RegistrationOptions>();
}
static RegistrationOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RegistrationOptions>(isolate);
}
static RegistrationOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RegistrationOptions();
explicit  RegistrationOptions(v8::Isolate* isolate);

bool hasScope() const {
  return has_scope_;
}
const String& scope() const {
  DCHECK(hasScope());
return member_scope_;
}
String getScopeOr(const String& fallback_value) const;
String getScopeOr(String&& fallback_value) const;
void setScope(const String& value);
void setScope(String&& value);

bool hasType() const {
  return true;
}
V8WorkerType type() const {
  return member_type_;
}
void setType(V8WorkerType value) {
  member_type_ = value;
}
void setType(V8WorkerType::Enum value) {
  member_type_ = V8WorkerType(value);
}

bool hasUpdateViaCache() const {
  return true;
}
V8ServiceWorkerUpdateViaCache updateViaCache() const {
  return member_update_via_cache_;
}
void setUpdateViaCache(V8ServiceWorkerUpdateViaCache value) {
  member_update_via_cache_ = value;
}
void setUpdateViaCache(V8ServiceWorkerUpdateViaCache::Enum value) {
  member_update_via_cache_ = V8ServiceWorkerUpdateViaCache(value);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_scope_ = false;

String member_scope_;
V8WorkerType member_type_{V8WorkerType::Enum::kClassic};
V8ServiceWorkerUpdateViaCache member_update_via_cache_{V8ServiceWorkerUpdateViaCache::Enum::kImports};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_REGISTRATION_OPTIONS_H_
