// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PUSH_SUBSCRIPTION_CHANGE_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PUSH_SUBSCRIPTION_CHANGE_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_extendable_event_init.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class PushSubscription;

class MODULES_EXPORT PushSubscriptionChangeEventInit : public ExtendableEventInit {
  
  public:
static PushSubscriptionChangeEventInit* Create() {
  return MakeGarbageCollected<PushSubscriptionChangeEventInit>();
}
static PushSubscriptionChangeEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<PushSubscriptionChangeEventInit>(isolate);
}
static PushSubscriptionChangeEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  PushSubscriptionChangeEventInit();
explicit  PushSubscriptionChangeEventInit(v8::Isolate* isolate);

bool hasNewSubscription() const {
  return has_new_subscription_;
}
PushSubscription* newSubscription() const {
  DCHECK(hasNewSubscription());
return member_new_subscription_.Get();
}
PushSubscription* getNewSubscriptionOr(PushSubscription* fallback_value) const {
  if (!hasNewSubscription()) {
  return fallback_value;
}
return member_new_subscription_.Get();
}
void setNewSubscription(PushSubscription* value) {
  member_new_subscription_ = value;
has_new_subscription_ = true;
DCHECK(member_new_subscription_);
}

bool hasOldSubscription() const {
  return has_old_subscription_;
}
PushSubscription* oldSubscription() const {
  DCHECK(hasOldSubscription());
return member_old_subscription_.Get();
}
PushSubscription* getOldSubscriptionOr(PushSubscription* fallback_value) const {
  if (!hasOldSubscription()) {
  return fallback_value;
}
return member_old_subscription_.Get();
}
void setOldSubscription(PushSubscription* value) {
  member_old_subscription_ = value;
has_old_subscription_ = true;
DCHECK(member_old_subscription_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = ExtendableEventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_new_subscription_ = false;
bool has_old_subscription_ = false;

Member<PushSubscription> member_new_subscription_;
Member<PushSubscription> member_old_subscription_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PUSH_SUBSCRIPTION_CHANGE_EVENT_INIT_H_
