// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_public_key_credential_request_options_js_on.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_authentication_extensions_client_inputs_js_on.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_public_key_credential_descriptor_js_on.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"allowCredentials",
"challenge",
"challengeUrl",
"extensions",
"hints",
"rpId",
"timeout",
"userVerification",
};


}  // namespace 

PublicKeyCredentialRequestOptionsJSON* PublicKeyCredentialRequestOptionsJSON::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  PublicKeyCredentialRequestOptionsJSON* dictionary = MakeGarbageCollected<PublicKeyCredentialRequestOptionsJSON>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "PublicKeyCredentialRequestOptionsJSON";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 PublicKeyCredentialRequestOptionsJSON::PublicKeyCredentialRequestOptionsJSON() {
  
}

 PublicKeyCredentialRequestOptionsJSON::PublicKeyCredentialRequestOptionsJSON(v8::Isolate* isolate) {
  
}



void PublicKeyCredentialRequestOptionsJSON::setAllowCredentials(const HeapVector<Member<PublicKeyCredentialDescriptorJSON>>& value) {
  member_allow_credentials_ = value;
}

void PublicKeyCredentialRequestOptionsJSON::setAllowCredentials(HeapVector<Member<PublicKeyCredentialDescriptorJSON>>&& value) {
  member_allow_credentials_ = std::move(value);
}




String PublicKeyCredentialRequestOptionsJSON::getChallengeOr(const String& fallback_value) const {
  if (!hasChallenge()) {
  return fallback_value;
}
return member_challenge_;
}

String PublicKeyCredentialRequestOptionsJSON::getChallengeOr(String&& fallback_value) const {
  if (!hasChallenge()) {
  return std::move(fallback_value);
}
return member_challenge_;
}

void PublicKeyCredentialRequestOptionsJSON::setChallenge(const String& value) {
  member_challenge_ = value;
has_challenge_ = true;
}

void PublicKeyCredentialRequestOptionsJSON::setChallenge(String&& value) {
  member_challenge_ = std::move(value);
has_challenge_ = true;
}




String PublicKeyCredentialRequestOptionsJSON::getChallengeUrlOr(const String& fallback_value) const {
  if (!hasChallengeUrl()) {
  return fallback_value;
}
return member_challenge_url_;
}

String PublicKeyCredentialRequestOptionsJSON::getChallengeUrlOr(String&& fallback_value) const {
  if (!hasChallengeUrl()) {
  return std::move(fallback_value);
}
return member_challenge_url_;
}

void PublicKeyCredentialRequestOptionsJSON::setChallengeUrl(const String& value) {
  member_challenge_url_ = value;
has_challenge_url_ = true;
}

void PublicKeyCredentialRequestOptionsJSON::setChallengeUrl(String&& value) {
  member_challenge_url_ = std::move(value);
has_challenge_url_ = true;
}











void PublicKeyCredentialRequestOptionsJSON::setHints(const Vector<String>& value) {
  member_hints_ = value;
}

void PublicKeyCredentialRequestOptionsJSON::setHints(Vector<String>&& value) {
  member_hints_ = std::move(value);
}




String PublicKeyCredentialRequestOptionsJSON::getRpIdOr(const String& fallback_value) const {
  if (!hasRpId()) {
  return fallback_value;
}
return member_rp_id_;
}

String PublicKeyCredentialRequestOptionsJSON::getRpIdOr(String&& fallback_value) const {
  if (!hasRpId()) {
  return std::move(fallback_value);
}
return member_rp_id_;
}

void PublicKeyCredentialRequestOptionsJSON::setRpId(const String& value) {
  member_rp_id_ = value;
has_rp_id_ = true;
}

void PublicKeyCredentialRequestOptionsJSON::setRpId(String&& value) {
  member_rp_id_ = std::move(value);
has_rp_id_ = true;
}











void PublicKeyCredentialRequestOptionsJSON::setUserVerification(const String& value) {
  member_user_verification_ = value;
}

void PublicKeyCredentialRequestOptionsJSON::setUserVerification(String&& value) {
  member_user_verification_ = std::move(value);
}




void PublicKeyCredentialRequestOptionsJSON::Trace(Visitor* visitor) const {
  visitor->Trace(member_allow_credentials_);
visitor->Trace(member_extensions_);
bindings::InputDictionaryBase::Trace(visitor);
}

void PublicKeyCredentialRequestOptionsJSON::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "PublicKeyCredentialRequestOptionsJSON";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("allowCredentials");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<PublicKeyCredentialDescriptorJSON>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_allow_credentials_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("challenge");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_challenge_, member_challenge_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::WebAuthenticationChallengeUrlEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("challengeUrl");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_challenge_url_, member_challenge_url_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("extensions");
if (!bindings::GetDictionaryMemberFromV8Object<AuthenticationExtensionsClientInputsJSON, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_extensions_, member_extensions_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("hints");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), fallback_presence_var, member_hints_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("rpId");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_rp_id_, member_rp_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("timeout");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_timeout_, member_timeout_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("userVerification");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), fallback_presence_var, member_user_verification_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> PublicKeyCredentialRequestOptionsJSON::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
