// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_public_key_credential_request_options.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_arraybuffer_arraybufferview.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_authentication_extensions_client_inputs.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_public_key_credential_descriptor.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"allowCredentials",
"challenge",
"challengeUrl",
"extensions",
"hints",
"rpId",
"timeout",
"userVerification",
};


}  // namespace 

PublicKeyCredentialRequestOptions* PublicKeyCredentialRequestOptions::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  PublicKeyCredentialRequestOptions* dictionary = MakeGarbageCollected<PublicKeyCredentialRequestOptions>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "PublicKeyCredentialRequestOptions";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 PublicKeyCredentialRequestOptions::PublicKeyCredentialRequestOptions() {
  
}

 PublicKeyCredentialRequestOptions::PublicKeyCredentialRequestOptions(v8::Isolate* isolate) {
  
}



void PublicKeyCredentialRequestOptions::setAllowCredentials(const HeapVector<Member<PublicKeyCredentialDescriptor>>& value) {
  member_allow_credentials_ = value;
}

void PublicKeyCredentialRequestOptions::setAllowCredentials(HeapVector<Member<PublicKeyCredentialDescriptor>>&& value) {
  member_allow_credentials_ = std::move(value);
}











String PublicKeyCredentialRequestOptions::getChallengeUrlOr(const String& fallback_value) const {
  if (!hasChallengeUrl()) {
  return fallback_value;
}
return member_challenge_url_;
}

String PublicKeyCredentialRequestOptions::getChallengeUrlOr(String&& fallback_value) const {
  if (!hasChallengeUrl()) {
  return std::move(fallback_value);
}
return member_challenge_url_;
}

void PublicKeyCredentialRequestOptions::setChallengeUrl(const String& value) {
  member_challenge_url_ = value;
has_challenge_url_ = true;
}

void PublicKeyCredentialRequestOptions::setChallengeUrl(String&& value) {
  member_challenge_url_ = std::move(value);
has_challenge_url_ = true;
}











void PublicKeyCredentialRequestOptions::setHints(const Vector<String>& value) {
  member_hints_ = value;
}

void PublicKeyCredentialRequestOptions::setHints(Vector<String>&& value) {
  member_hints_ = std::move(value);
}




String PublicKeyCredentialRequestOptions::getRpIdOr(const String& fallback_value) const {
  if (!hasRpId()) {
  return fallback_value;
}
return member_rp_id_;
}

String PublicKeyCredentialRequestOptions::getRpIdOr(String&& fallback_value) const {
  if (!hasRpId()) {
  return std::move(fallback_value);
}
return member_rp_id_;
}

void PublicKeyCredentialRequestOptions::setRpId(const String& value) {
  member_rp_id_ = value;
has_rp_id_ = true;
}

void PublicKeyCredentialRequestOptions::setRpId(String&& value) {
  member_rp_id_ = std::move(value);
has_rp_id_ = true;
}











String PublicKeyCredentialRequestOptions::getUserVerificationOr(const String& fallback_value) const {
  if (!hasUserVerification()) {
  return fallback_value;
}
return member_user_verification_;
}

String PublicKeyCredentialRequestOptions::getUserVerificationOr(String&& fallback_value) const {
  if (!hasUserVerification()) {
  return std::move(fallback_value);
}
return member_user_verification_;
}

void PublicKeyCredentialRequestOptions::setUserVerification(const String& value) {
  member_user_verification_ = value;
has_user_verification_ = true;
}

void PublicKeyCredentialRequestOptions::setUserVerification(String&& value) {
  member_user_verification_ = std::move(value);
has_user_verification_ = true;
}




void PublicKeyCredentialRequestOptions::Trace(Visitor* visitor) const {
  visitor->Trace(member_allow_credentials_);
visitor->Trace(member_challenge_);
visitor->Trace(member_extensions_);
bindings::DictionaryBase::Trace(visitor);
}

void PublicKeyCredentialRequestOptions::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void PublicKeyCredentialRequestOptions::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAllowCredentials()) {
  values[0] = ToV8Traits<IDLSequence<PublicKeyCredentialDescriptor>>::ToV8(script_state, member_allow_credentials_);
DCHECK(!values[0].IsEmpty());
}
if (hasChallenge()) {
  values[1] = ToV8Traits<V8UnionArrayBufferOrArrayBufferView>::ToV8(script_state, member_challenge_.Get());
DCHECK(!values[1].IsEmpty());
}
if (RuntimeEnabledFeatures::WebAuthenticationChallengeUrlEnabled()) {
  if (hasChallengeUrl()) {
  values[2] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_challenge_url_);
DCHECK(!values[2].IsEmpty());
}
}
if (hasExtensions()) {
  values[3] = ToV8Traits<AuthenticationExtensionsClientInputs>::ToV8(script_state, member_extensions_.Get());
DCHECK(!values[3].IsEmpty());
}
if (hasHints()) {
  values[4] = ToV8Traits<IDLSequence<IDLString>>::ToV8(script_state, member_hints_);
DCHECK(!values[4].IsEmpty());
}
if (hasRpId()) {
  values[5] = ToV8Traits<IDLString>::ToV8(script_state, member_rp_id_);
DCHECK(!values[5].IsEmpty());
}
if (hasTimeout()) {
  values[6] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_timeout_);
DCHECK(!values[6].IsEmpty());
}
if (hasUserVerification()) {
  values[7] = ToV8Traits<IDLString>::ToV8(script_state, member_user_verification_);
DCHECK(!values[7].IsEmpty());
}
}

const void* PublicKeyCredentialRequestOptions::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> PublicKeyCredentialRequestOptions::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void PublicKeyCredentialRequestOptions::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "PublicKeyCredentialRequestOptions";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("allowCredentials");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<PublicKeyCredentialDescriptor>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_allow_credentials_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("challenge");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionArrayBufferOrArrayBufferView, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_challenge_, member_challenge_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::WebAuthenticationChallengeUrlEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("challengeUrl");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_challenge_url_, member_challenge_url_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("extensions");
if (!bindings::GetDictionaryMemberFromV8Object<AuthenticationExtensionsClientInputs, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_extensions_, member_extensions_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("hints");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), fallback_presence_var, member_hints_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("rpId");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_rp_id_, member_rp_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("timeout");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_timeout_, member_timeout_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("userVerification");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_user_verification_, member_user_verification_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> PublicKeyCredentialRequestOptions::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
