// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PUBLIC_KEY_CREDENTIAL_CREATION_OPTIONS_JS_ON_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PUBLIC_KEY_CREDENTIAL_CREATION_OPTIONS_JS_ON_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class AuthenticationExtensionsClientInputsJSON;
class AuthenticatorSelectionCriteria;
class ExceptionState;
class PublicKeyCredentialDescriptorJSON;
class PublicKeyCredentialParameters;
class PublicKeyCredentialRpEntity;
class PublicKeyCredentialUserEntityJSON;

class MODULES_EXPORT PublicKeyCredentialCreationOptionsJSON : public bindings::InputDictionaryBase {
  
  public:
static PublicKeyCredentialCreationOptionsJSON* Create() {
  return MakeGarbageCollected<PublicKeyCredentialCreationOptionsJSON>();
}
static PublicKeyCredentialCreationOptionsJSON* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<PublicKeyCredentialCreationOptionsJSON>(isolate);
}
static PublicKeyCredentialCreationOptionsJSON* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  PublicKeyCredentialCreationOptionsJSON();
explicit  PublicKeyCredentialCreationOptionsJSON(v8::Isolate* isolate);

bool hasAttestation() const {
  return true;
}
const String& attestation() const {
  return member_attestation_;
}
void setAttestation(const String& value);
void setAttestation(String&& value);

bool hasAuthenticatorSelection() const {
  return has_authenticator_selection_;
}
AuthenticatorSelectionCriteria* authenticatorSelection() const {
  DCHECK(hasAuthenticatorSelection());
return member_authenticator_selection_.Get();
}
AuthenticatorSelectionCriteria* getAuthenticatorSelectionOr(AuthenticatorSelectionCriteria* fallback_value) const {
  if (!hasAuthenticatorSelection()) {
  return fallback_value;
}
return member_authenticator_selection_.Get();
}
void setAuthenticatorSelection(AuthenticatorSelectionCriteria* value) {
  member_authenticator_selection_ = value;
has_authenticator_selection_ = true;
DCHECK(member_authenticator_selection_);
}

bool hasChallenge() const {
  return true;
}
const String& challenge() const {
  return member_challenge_;
}
void setChallenge(const String& value);
void setChallenge(String&& value);

bool hasExcludeCredentials() const {
  return true;
}
const HeapVector<Member<PublicKeyCredentialDescriptorJSON>>& excludeCredentials() const {
  return member_exclude_credentials_;
}
void setExcludeCredentials(const HeapVector<Member<PublicKeyCredentialDescriptorJSON>>& value);
void setExcludeCredentials(HeapVector<Member<PublicKeyCredentialDescriptorJSON>>&& value);

bool hasExtensions() const {
  return has_extensions_;
}
AuthenticationExtensionsClientInputsJSON* extensions() const {
  DCHECK(hasExtensions());
return member_extensions_.Get();
}
AuthenticationExtensionsClientInputsJSON* getExtensionsOr(AuthenticationExtensionsClientInputsJSON* fallback_value) const {
  if (!hasExtensions()) {
  return fallback_value;
}
return member_extensions_.Get();
}
void setExtensions(AuthenticationExtensionsClientInputsJSON* value) {
  member_extensions_ = value;
has_extensions_ = true;
DCHECK(member_extensions_);
}

bool hasHints() const {
  return true;
}
const Vector<String>& hints() const {
  return member_hints_;
}
void setHints(const Vector<String>& value);
void setHints(Vector<String>&& value);

bool hasPubKeyCredParams() const {
  return true;
}
const HeapVector<Member<PublicKeyCredentialParameters>>& pubKeyCredParams() const {
  return member_pub_key_cred_params_;
}
void setPubKeyCredParams(const HeapVector<Member<PublicKeyCredentialParameters>>& value);
void setPubKeyCredParams(HeapVector<Member<PublicKeyCredentialParameters>>&& value);

bool hasRp() const {
  return true;
}
PublicKeyCredentialRpEntity* rp() const {
  return member_rp_.Get();
}
void setRp(PublicKeyCredentialRpEntity* value) {
  member_rp_ = value;
DCHECK(member_rp_);
}

bool hasTimeout() const {
  return has_timeout_;
}
uint32_t timeout() const {
  DCHECK(hasTimeout());
return member_timeout_;
}
uint32_t getTimeoutOr(uint32_t fallback_value) const {
  if (!hasTimeout()) {
  return fallback_value;
}
return member_timeout_;
}
void setTimeout(uint32_t value) {
  member_timeout_ = value;
has_timeout_ = true;
}

bool hasUser() const {
  return true;
}
PublicKeyCredentialUserEntityJSON* user() const {
  return member_user_.Get();
}
void setUser(PublicKeyCredentialUserEntityJSON* value) {
  member_user_ = value;
DCHECK(member_user_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 10;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_authenticator_selection_ = false;
bool has_extensions_ = false;
bool has_timeout_ = false;

String member_attestation_{"none"};
Member<AuthenticatorSelectionCriteria> member_authenticator_selection_;
String member_challenge_;
HeapVector<Member<PublicKeyCredentialDescriptorJSON>> member_exclude_credentials_;
Member<AuthenticationExtensionsClientInputsJSON> member_extensions_;
Vector<String> member_hints_;
HeapVector<Member<PublicKeyCredentialParameters>> member_pub_key_cred_params_;
Member<PublicKeyCredentialRpEntity> member_rp_;
uint32_t member_timeout_;
Member<PublicKeyCredentialUserEntityJSON> member_user_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PUBLIC_KEY_CREDENTIAL_CREATION_OPTIONS_JS_ON_H_
