// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_proofreader_create_core_options.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"correctionExplanationLanguage",
"expectedInputLanguages",
"includeCorrectionExplanations",
"includeCorrectionTypes",
};


}  // namespace 

ProofreaderCreateCoreOptions* ProofreaderCreateCoreOptions::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  ProofreaderCreateCoreOptions* dictionary = MakeGarbageCollected<ProofreaderCreateCoreOptions>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "ProofreaderCreateCoreOptions";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 ProofreaderCreateCoreOptions::ProofreaderCreateCoreOptions() {
  
}

 ProofreaderCreateCoreOptions::ProofreaderCreateCoreOptions(v8::Isolate* isolate) {
  
}



String ProofreaderCreateCoreOptions::getCorrectionExplanationLanguageOr(const String& fallback_value) const {
  if (!hasCorrectionExplanationLanguage()) {
  return fallback_value;
}
return member_correction_explanation_language_;
}

String ProofreaderCreateCoreOptions::getCorrectionExplanationLanguageOr(String&& fallback_value) const {
  if (!hasCorrectionExplanationLanguage()) {
  return std::move(fallback_value);
}
return member_correction_explanation_language_;
}

void ProofreaderCreateCoreOptions::setCorrectionExplanationLanguage(const String& value) {
  member_correction_explanation_language_ = value;
has_correction_explanation_language_ = true;
}

void ProofreaderCreateCoreOptions::setCorrectionExplanationLanguage(String&& value) {
  member_correction_explanation_language_ = std::move(value);
has_correction_explanation_language_ = true;
}




Vector<String> ProofreaderCreateCoreOptions::getExpectedInputLanguagesOr(const Vector<String>& fallback_value) const {
  if (!hasExpectedInputLanguages()) {
  return fallback_value;
}
return member_expected_input_languages_;
}

Vector<String> ProofreaderCreateCoreOptions::getExpectedInputLanguagesOr(Vector<String>&& fallback_value) const {
  if (!hasExpectedInputLanguages()) {
  return std::move(fallback_value);
}
return member_expected_input_languages_;
}

void ProofreaderCreateCoreOptions::setExpectedInputLanguages(const Vector<String>& value) {
  member_expected_input_languages_ = value;
has_expected_input_languages_ = true;
}

void ProofreaderCreateCoreOptions::setExpectedInputLanguages(Vector<String>&& value) {
  member_expected_input_languages_ = std::move(value);
has_expected_input_languages_ = true;
}














void ProofreaderCreateCoreOptions::Trace(Visitor* visitor) const {
  bindings::InputDictionaryBase::Trace(visitor);
}

void ProofreaderCreateCoreOptions::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "ProofreaderCreateCoreOptions";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("correctionExplanationLanguage");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_correction_explanation_language_, member_correction_explanation_language_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("expectedInputLanguages");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_expected_input_languages_, member_expected_input_languages_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("includeCorrectionExplanations");
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_include_correction_explanations_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("includeCorrectionTypes");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_include_correction_types_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> ProofreaderCreateCoreOptions::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
